<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Calendaradmin extends CI_Controller 
{
	var $location='';
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/calendar_model');
		$this->currentUser=$this->session->userdata("admin_data");
		$this->load->model("mobile/mobileNotifications_model");
    }
	function index()
	{
		$views = array( 'calendar/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Calendar Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->calendar_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Calendar Listing ajax request");
	}
	
	function add_edit_calendar($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('calendaradmin');
			}
			else
			{
				if($this->currentUser->allow_global==0 && $this->currentUser->id!=$calendarData->user_id)
				{
					$this->session->set_flashdata("calendar_error",1);
					redirect('calendaradmin');
				}
			}
		}
		

		if(isset($_POST["save_calendar"]))
		{
			if(!isset($_POST['description']) || (!isset($_POST['swamiji']) && !isset($_POST['balaswamiji']) && !isset($_POST['dattapeetham']) ))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('calendaradmin/add_edit_calendar/'.$id);
			}

			$this->form_validation->set_rules('event_name', 'Calendar Event', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
			if(isset($_POST['start_date']))
				$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|calendarDateRangeCheck');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('calendaradmin/add_edit_calendar/'.$id);
				return;
			}

			$saved=$this->calendar_model->save($id);
			if($id==0)
			{
				$this->session->set_flashdata("calendar_created",1);
			}
			else
				$this->session->set_flashdata("calendar_saved",1);
			redirect('calendaradmin/add_edit_calendar/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($calendarData)) )
			{
				redirect('calendaradmin');
			}
			$views = array('calendar/admin/add_edit_calendar');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['calendarData']=$calendarData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				goto end;
			}
			if($this->currentUser->allow_global==0 && $this->currentUser->id!=$calendarData->user_id)
			{
				goto end;
			}
			$r=$this->calendar_model->delete($id);
			if($r)
			{
				//deleting related notification data also
				$this->mobileNotifications_model->remove($id,'liveupdates');
				$data['flag']=1;
				$data['event_name']=$calendarData->event_name;
				$this->logaction->log($this->service,"Admin - Calendar event '".$calendarData->event_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
}
?>