<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Ashrams extends CI_Controller 
{
	var $service='ashrams';
    var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
    function __construct()
	{
        parent::__construct();
		$this->load->model('ashrams/ashrams_model');
        $this->load->model('ashrams/ashram_calendar_model');
        $this->load->model('ashrams/announcements_model');
		$this->load->model('locations_model');
		$this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
        $this->load->model('content/events_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model("content/downloads_categories_model");
		if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
    }
    public function index() 
    {
        $data['views'] = array('ashrams/public/list');
        $data['acountries']=$this->ashrams_model->getCountries();
        $this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listc()
    {
        $list=$this->ashrams_model->listPublic($this->session->userdata("admin_data"),$this->session->userdata("user_data"));
        if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
        {
            $this->search_log_model->log(trim($_POST['search_text']),'ashrams');
        }
        echo json_encode($list);
    }

    public function checkpublicdisplay($displayCheck=1)
    {
        if($displayCheck==0)
        {
            if(empty($this->currentUser))
                return "0";
            if(!empty($this->currentUser) && $this->currentUser->roles !=1 && $this->currentUser->roles !=4 && $this->currentUser->roles !=3)
                return "0";
        }
        else
        {
            return "1";
        }
    }
    public function view($slug='')
    {
    	if($slug!='')
    	{
    		$ashramData=$this->ashrams_model->ashramDataBySlug($slug);
    		if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) !="0")
    		{
	    		$data = array('ashramData'=>$ashramData);
				$data['views'] = array('ashrams/public/view');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
    		else
    		{
    			$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
    		}
    	}
    	else
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
    	}
    }
    public function calendar($slug='') 
    {
        if($slug!='')
        {
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $yearmonths=$this->ashram_calendar_model->getYearMonths($ashramData->id);
                $data = array('ashramData'=>$ashramData);
                $data['yearmonths']=$yearmonths;
                $data['views'] = array('ashrams/public/list_calendar');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function listcalendar($slug='')
    {
        if($slug!='')
        {
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData))
            {
                $list=$this->ashram_calendar_model->listPublic($ashramData->id);
                echo json_encode($list);
            }
        }
    }
    public function announcements($slug='') 
    {
        if($slug!='')
        {
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $yearmonths=$this->announcements_model->getYearMonths($ashramData->id);
                $data = array('ashramData'=>$ashramData);
                $data['yearmonths']=$yearmonths;
                $data['views'] = array('ashrams/public/list_announcements');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function listannouncements($slug='')
    {
        if($slug!='')
        {
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData))
            {
                $list=$this->announcements_model->listPublic($ashramData->id);
                echo json_encode($list);
            }
        }
    }

    /**
     * List All Events By Ashram
     * 
     * @param     $slug Ashram Slug
     * @version   1.1
     * @author    Baji Shaik <bajidotwork@gmaial.com>
     */
    public function events($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/events_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('content/events_images_model');
            $this->load->model('category/categories_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $yearmonths=$this->events_model->getYearMonths($ashramData->id);
                $data = array('ashramData'=>$ashramData);
                $data['yearmonths']     =$yearmonths;
                $data['ashram_id']      =$ashramData->id;
                $data['ashram_slug']    = $ashramData->slug;
                $this->categories_model->fetchCategories(0,$ashramData->id);
                $data['views'] = array('events/public/list');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    /**
     * View Events By Ashram
     * @param       $ashram_slug
     * @param       $year
     * @param       $events_slug
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function view_events($ashram_slug='', $year=0, $events_slug='')
    {
        if($events_slug!='' && $ashram_slug!='')
        {
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventDataBySlug($events_slug);
            
            $ashramData=$this->ashrams_model->ashramDataBySlug($ashram_slug);
            if(!empty($eventData['event']) && !empty($ashramData))
            {
                if($eventData['event']->status!=1)
                {
                    goto end;
                }
                $eventAshramId = $eventData['event']->ashram_id;
                if($eventAshramId != $ashramData->id)
                {
                    goto end;
                }
                if($eventData['event']->year!=$year)
                {
                    goto end;
                }
                $data = array('eventData'=>$eventData);
                if($eventAshramId){
                    $this->categories_model->fetchCategories(0,$eventAshramId);
                    $data['ashramData']=$this->ashrams_model->ashramData($eventAshramId);
                }
                $data['views'] = array('events/public/view');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        end:
        $data['views'] = array('common/public/error');
        $this->load->view(FRONTEND_TEMPLATE,$data);
    }

     /**
     * View Events Category By Ashram
     * @param       $ashram_slug
     * @param       $category
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function eventscategory($ashram_slug='',$category='')
    {
        if(!$ashram_slug)
        {
            goto end;
        }
        $data = array('category'=>$category);
        $data['service'] = "ashrams";
        $ashramData=$this->ashrams_model->ashramDataBySlug($ashram_slug);
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories(0,$ashramData->id);
        if(isset($this->categories_model->categoriesList['categories'][$category]))
        {
            $data['categoryExist']=1;
            $data['categoryName']=htmlentities($this->categories_model->categoriesList['categories'][$category]->category);
            $data['categoryId']=$this->categories_model->categoriesList['categories'][$category]->id;
            if($ashramData->id)
            {
                $data['ashramData']=$this->ashrams_model->ashramData($ashramData->id);
            }
        }
        else
        {
            $data['categoryName']="All Categories";
            $data['categoryId']=0;
        }
        if(!$ashramData->id)
        {
            goto end;
        }
        else
        {
            $data['views'] = array('events/public/category_view');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        end:
        $data['views'] = array('common/public/error');
        $this->load->view(FRONTEND_TEMPLATE,$data);
    }

    /**
     * Categories By Ashram Ajax Listing
     * @param       $ashramId
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function listbycategory($ashramId='')
    {
        $categoryId=0;
        if(isset($_POST['category']) && $ashramId)
        {
            $category=$_POST['category'];
            $this->load->model('category/categories_model');
            $this->categories_model->fetchCategories(0,$ashramId);
            if(isset($this->categories_model->categoriesList['categories'][$category]))
            {
                $categoryId=$this->categories_model->categoriesList['categories'][$category]->id;
            }
        }
        $list=$this->events_model->listPublicByCategory($categoryId,$ashramId);
        echo json_encode($list);
    }

    public function speeches($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/speeches_model');
            $this->load->model('category/categories_model');
            $this->categories_model->fetchCategories(1);
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $yearmonths=$this->speeches_model->getYearMonths($ashramData->id);
                $data = array('ashramData'=>$ashramData);
                $data['yearmonths']=$yearmonths;
                $data['ashram_id']=$ashramData->id;
                $data['ashram_slug']=$ashramData->slug;
                $data['views'] = array('speeches/public/list');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    /**
     * View Speeches By Ashram
     * @param       $ashram_slug
     * @param       $year
     * @param       $speeches_slug
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function view_speeches($ashram_slug='', $year=0, $month,$day,$speeches_slug='')
    {
        if($speeches_slug!='' && $ashram_slug!='')
        {
            $this->load->model('category/categories_model');
            $this->load->model('content/speeches_model');

            $speechData=$this->speeches_model->speechDataBySlugDate($speeches_slug,$year,$month,$day);
            $ashramData=$this->ashrams_model->ashramDataBySlug($ashram_slug);
            if(!empty($speechData) && !empty($ashramData))
            {
                $speechAshramId = $speechData->ashram_id;
                if($speechAshramId != $ashramData->id)
                {
                    goto end;
                }
                if($speechData->year!=$year)
                {
                    goto end;
                }
                $data = array('speechData'=>$speechData);
                if($speechAshramId){
                    $this->categories_model->fetchCategories(1);
                    $data['ashramData']=$this->ashrams_model->ashramData($speechAshramId);
                }
                $data['views'] = array('speeches/public/view');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        end:
        $data['views'] = array('common/public/error');
        $this->load->view(FRONTEND_TEMPLATE,$data);
    }

    /**
     * View Speeches Category By Ashram
     * @param       $ashram_slug
     * @param       $category
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function speechescategory($ashram_slug='',$category='')
    {
        if(!$ashram_slug)
        {
            goto end;
        }
        $data = array('category'=>$category);
        $data['service'] = "ashrams";
        $ashramData=$this->ashrams_model->ashramDataBySlug($ashram_slug);
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories(1,0);
        if(isset($this->categories_model->categoriesList['categories'][$category]))
        {
            $data['categoryExist']=1;
            $data['categoryName']=htmlentities($this->categories_model->categoriesList['categories'][$category]->category);
            $data['categoryId']=$this->categories_model->categoriesList['categories'][$category]->id;
            if($ashramData->id)
            {
                $data['ashramData']=$this->ashrams_model->ashramData($ashramData->id);
            }
        }
        else
        {
            $data['categoryName']="All Categories";
            $data['categoryId']=0;
        }
        if(!$ashramData->id)
        {
            goto end;
        }
        else
        {
            $data['views'] = array('speeches/public/category_view');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        end:
        $data['views'] = array('common/public/error');
        $this->load->view(FRONTEND_TEMPLATE,$data);
    }

    /**
     * Categories By Ashram Ajax Listing
     * @param       $ashramId
     * @version     1.1
     * @author      Baji Shaik <bajidotwork@gmaial.com>
     */
    public function listbyspeechescategory($ashramId='')
    {
        $categoryId=0;
        if(isset($_POST['category']) && $ashramId)
        {
            $category=$_POST['category'];
            $this->load->model('category/categories_model');
            $this->load->model('content/speeches_model');
            $this->categories_model->fetchCategories(1);
            if(isset($this->categories_model->categoriesList['categories'][$category]))
            {
                $categoryId=$this->categories_model->categoriesList['categories'][$category]->id;
            }
        }
        $list=$this->speeches_model->listPublicByCategory($categoryId,$ashramId);
        echo json_encode($list);
    }

    public function videos($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/videos_model');
            $this->load->model('content/videos_albums_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $data = array('ashramData'=>$ashramData);
                $data['ashram_id']=$ashramData->id;
                $data['views'] = array('videos/public/list');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function videos_albums($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/videos_model');
            $this->load->model('content/videos_albums_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $data = array('ashramData'=>$ashramData);
                $data['ashram_id']=$ashramData->id;
                $data['views'] = array('videos/public/list_albums');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function photos($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/album_model');
            $this->load->model('content/album_images_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $data = array('ashramData'=>$ashramData);
                $data['ashram_id']=$ashramData->id;
                $data['views'] = array('photoalbums/public/list');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function photos_albums($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/album_model');
            $this->load->model('content/album_images_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $data = array('ashramData'=>$ashramData);
                $data['ashram_id']=$ashramData->id;
                $data['views'] = array('photoalbums/public/list_albums');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }
    public function downloads($slug='')
    {
        if($slug!='')
        {
            $this->load->model('content/downloads_model');
            $ashramData=$this->ashrams_model->ashramDataBySlug($slug);
            if(!empty($ashramData) && $this->checkpublicdisplay($ashramData->is_public_display) != "0")
            {
                $data = array('ashramData'=>$ashramData);
                $data['ashram_id']=$ashramData->id;
                $data['download_cats'] = $this->downloads_categories_model->getList();
                $data['views'] = array('downloads/public/list');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    public function getCurrenciesByAshram($ashram_id=0)
    {
        $currencies = [];
        if($ashram_id>0)
        {
            $this->load->model('currencies_model');
            $currencies=$this->currencies_model->getByAshram($ashram_id);
        }
        echo json_encode($currencies);
    }
}
?>