<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Address_book extends CI_Controller 
{
	var $service="others";
	var $currentUser='';
    function __construct() 
    {
        parent::__construct();
		$this->load->model("others/addressbook_model");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
    }

    public function index() 
	{
        $data = array('views'=>array("address_book/admin/list"));
        $this->load->view(ADMIN_TEMPLATE,$data);
    }
    public function listcontacts($excel=0)
	{
		$list=$this->addressbook_model->listContactsAjaxAdmin($this->currentUser->id,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Address Book listing ajax request");
		
	}
	public function add_edit_contact($id=0)
	{
		if($id)
		{
			$contactData=$this->addressbook_model->contactData($id);
			if(empty($contactData) || $this->currentUser->id!=$contactData->user_id)
			{
				$this->session->set_flashdata("contact_error",1);
				redirect("/address_book");
			}
		}
		else
			$contactData=array();

		if(isset($_POST["add_contact"]))
		{
			if(!isset($_POST['email']) || !isset($_POST['phone']) || !isset($_POST['address']))
			{
				$this->session->set_flashdata("contact_error",1);
				redirect('address_book/add_edit_contact/'.$id);
			}

			$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('email', 'Email ID', 'trim|min_length[6]|max_length[100]|valid_email_custom');
			$this->form_validation->set_rules('phone', 'Phone', 'trim|min_length[10]|max_length[100]');
			$this->form_validation->set_rules('address', 'Address', 'trim|min_length[3]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("contact_error",1);
				redirect('address_book/add_edit_contact/'.$id);
				return;
			}
			
			$saved=$this->addressbook_model->save($id,$_POST['name'],$_POST['email'],$_POST['phone'],$_POST['address']);
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("contact_saved",1);
				}
				else
				{
					$this->session->set_flashdata("contact_created",1);
				}
			}
			redirect('address_book/add_edit_contact/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'address_book/admin/add_edit_contact' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['contact_data']=$contactData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$contactData=$this->addressbook_model->contactData($id);
			if(!empty($contactData) && $this->currentUser->id==$contactData->user_id)
			{
				$r=$this->addressbook_model->delete($id,$contactData);
				if($r)
				{
					$data['flag']=1;
					$data['name']=$contactData->name;
				}
			}
		}
		echo json_encode($data);
	}
}
?>