<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['404_override'] = 'myerror';
$route['translate_uri_dashes'] = FALSE;


$route['api/speeches/(:num)'] = 'api/speeches/index/$1';

$route['api/example/users'] = 'api/example/users';
$route['api/example/users/(:num)'] = 'api/example/users/id/$1'; // Example 4
$route['api/example/users/(:num)(\.)([a-zA-Z0-9_-]+)(.*)'] = 'api/example/users/id/$1/format/$3$4'; // Example 8

require_once( BASEPATH .'database/DB.php');
$db =& DB("site_services");
if ($db->table_exists('dailypost_types'))
{
	$query = $db->get('dailypost_types');

	$result = $query->result();
	foreach( $result as $row )
	{
	    $route[ $row->slug]= "post/view/".$row->slug;
	    $route[ $row->slug."/(:num)"]= "post/view/".$row->slug."/$1";
	    $route[ $row->slug."/(:num)/(:num)"]= "post/view/".$row->slug."/$1/$2";
	    $route[ $row->slug."/(:num)/(:num)/(:any)"]= "post/view/".$row->slug."/$1/$2/$3";
	}
}
/*Custom pages*/
$route['shodasha-kshetras']='shodasha_datta_kshetras';
$route['shodasha-datta-kshetras']='shodasha_datta_kshetras';
$route['swamiji-pratishthas']='swamiji_pratishthas';
$route['appaji-pratishthas']='swamiji_pratishthas';
$route['navanatha-kshetras']='navanatha_datta_kshetras';
$route['navanatha-datta-kshetras']='navanatha_datta_kshetras';
$route['datta-peetham']='datta_peetham';
$route['avadhoota-datta-peetham']='datta_peetham';
$route['dattapeetham']='datta_peetham';

$route['swamiji']='sri_swamiji';
$route['sriswamiji']='sri_swamiji';
$route['sri-swamiji']='sri_swamiji';
$route['appaji']='sri_swamiji';

$route['balaswamiji']='bala_swamiji';
$route['bala-swamiji']='bala_swamiji';
$route['sribalaswamiji']='bala_swamiji';
$route['sri-bala-swamiji']='bala_swamiji';
$route['sridattavijayanandateerthaswamiji']='bala_swamiji';
$route['sri-datta-vijayananda-teertha-swamiji']='bala_swamiji';

$route['sgsdattakamadhenu']='page/view/sgs-datta-kamadhenu';



$route['events/category']='events/category';
$route['events/category/(:any)']='events/category/$1';
$route['events/listbycategory']='events/listbycategory';
$route['events/listc']='events/listc';
$route['events/(:any)']='events/index/$1';
$route['events/(:any)/(:any)']='events/view/$1/$2';

$route['articles/category']='articles/category';
$route['articles/category/(:any)']='articles/category/$1';
$route['articles/listbycategory']='articles/listbycategory';
$route['articles/listc']='articles/listc';
$route['articles/(:any)']='articles/index/$1';
$route['articles/(:any)/(:any)']='articles/index/$1/$2';
$route['articles/(:any)/(:any)/(:any)']='articles/index/$1/$2/$3';
$route['articles/(:any)/(:any)/(:any)/(:any)']='articles/view/$1/$2/$3/$4';

//$route['subscriptions/view_newsletter/(:any)']='subscriptions/view/$1';

$route['speeches/category']='speeches/category';
$route['speeches/category/(:any)']='speeches/category/$1';
$route['speeches/listbycategory']='speeches/listbycategory';
$route['speeches/listc']='speeches/listc';
$route['speeches/(:any)']='speeches/index/$1';
$route['speeches/(:any)/(:any)']='speeches/index/$1/$2';
$route['speeches/(:any)/(:any)/(:any)']='speeches/index/$1/$2/$3';
$route['speeches/(:any)/(:any)/(:any)/(:any)']='speeches/view/$1/$2/$3/$4';

// knowledgebase
$route['kb'] = "knowledgebase/view/home";
$route['kb/(:any)'] = "knowledgebase/view/$1";
$route['kb/(:any)/(:any)'] = "knowledgebase/view/$1/$2";
$route['kb/(:any)/(:any)/(:any)'] = "knowledgebase/view/$1/$2/$3";
$route['kb/(?!kb_admin)(?!kb_user)(?!kb_guest)(:any)'] = "knowledgebase/view/$1";

$route['kb/kbsearch'] = 'knowledgebase/kbsearch/';


// knowledgebase

//ashrams
$route['ashrams/listc'] = 'ashrams/listc';
$route['ashrams/view'] = 'error/display';
$route['ashrams/view/(:any)'] = 'error/display';
$route['ashrams/(:any)'] = 'ashrams/view/$1';
$route['ashrams/(:any)/calendar'] = 'ashrams/calendar/$1';
$route['ashrams/(:any)/announcements'] = 'ashrams/announcements/$1';
$route['ashrams/(:any)/events'] = 'ashrams/events/$1';

$route['ashrams/(:any)/events/(:any)/(:any)'] = 'ashrams/view_events/$1/$2/$3';
$route['ashrams/(:any)/eventscategory/(:any)'] = 'ashrams/eventscategory/$1/$2';

$route['ashrams/(:any)/speeches'] = 'ashrams/speeches/$1';

$route['ashrams/(:any)/speeches/(:any)/(:any)/(:any)/(:any)'] = 'ashrams/view_speeches/$1/$2/$3/$4/$5';
$route['ashrams/(:any)/speechescategory/(:any)'] = 'ashrams/speechescategory/$1/$2';

$route['ashrams/(:any)/downloads'] = 'ashrams/downloads/$1';
$route['ashrams/(:any)/videos'] = 'ashrams/videos/$1';
$route['ashrams/(:any)/videos/albums'] = 'ashrams/videos_albums/$1';
$route['ashrams/(:any)/photos'] = 'ashrams/photos/$1';
$route['ashrams/(:any)/photos/albums'] = 'ashrams/photos_albums/$1';
//ashrams
$route['satsangs/listc'] = 'satsangs/listc';
$route['satsangs/view'] = 'error/display';
$route['satsangs/view/(:any)'] = 'error/display';
$route['satsangs/(:any)'] = 'satsangs/view/$1';

$route['ashramcenters/listc'] = 'ashramcenters/listc';
$route['ashramcenters/view'] = 'error/display';
$route['ashramcenters/view/(:any)'] = 'error/display';
$route['ashramcenters/(:any)'] = 'ashramcenters/view/$1';

$route['videos/view/(:any)'] = 'error/display';
$route['videos/album_view/(:any)'] = 'error/display';
$route['videos/(:num)'] = 'videos/view/$1';
$route['videos/albums/(:num)'] = 'videos/album_view/$1';


$route['photos/album_view/(:any)'] = 'error/display';
$route['photos/albums/(:num)'] = 'photos/album_view/$1';

//=====Emailqueues=====//
$route[ "usersadmin/listemails"]= "emailadmin/listemails/users";
$route[ "usersadmin/email_data"]= "emailadmin/email_data/users";
$route[ "usersadmin/email_data/(:num)"]= "emailadmin/email_data/users/1";
$route[ "usersadmin/email_resend"]= "emailadmin/resend/users";
$route[ "usersadmin/email_resend/(:any)"]= "emailadmin/resend/users/$1";
$route[ "usersadmin/bulk_resend"]= "emailadmin/bulk_resend/users";

$route[ "orders/listemails"]= "emailadmin/listemails/orders";
$route[ "orders/listsms"]= "smsadmin/listsms/orders";

//$route[ "ashramadmin/listemails"]= "emailadmin/listemails/ashrams";
$route[ "orders/email_data"]= "emailadmin/email_data/ashrams";
$route[ "orders/email_data/(:num)"]= "emailadmin/email_data/ashrams/1";
$route[ "orders/email_resend"]= "emailadmin/resend/ashrams";
$route[ "orders/email_resend/(:any)"]= "emailadmin/resend/ashrams/$1";
$route[ "orders/bulk_resend"]= "emailadmin/bulk_resend/ashrams";


//$route[ "orders/listsms"]= "smsadmin/listsms/ashrams";
$route[ "orders/sms_data"]= "smsadmin/sms_data/ashrams";
$route[ "orders/sms_data/(:num)"]= "smsadmin/sms_data/ashrams/1";
$route[ "orders/sms_resend"]= "smsadmin/resend/ashrams";
$route[ "orders/sms_resend/(:any)"]= "smsadmin/resend/ashrams/$1";
$route[ "orders/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/ashrams";


$route[ "satsangsadmin/listemails"]= "emailadmin/listemails/satsangs";
$route[ "satsangsadmin/email_data"]= "emailadmin/email_data/satsangs";
$route[ "satsangsadmin/email_data/(:num)"]= "emailadmin/email_data/satsangs/1";
$route[ "satsangsadmin/email_resend"]= "emailadmin/resend/satsangs";
$route[ "satsangsadmin/email_resend/(:any)"]= "emailadmin/resend/satsangs/$1";
$route[ "satsangsadmin/bulk_resend"]= "emailadmin/bulk_resend/satsangs";


$route[ "emailsmssubscriptionsadmin/listemails"]= "emailadmin/listemails/subscribe";
$route[ "emailsmssubscriptionsadmin/listsms"]= "smsadmin/listsms/subscribe";
$route[ "emailsmssubscriptionsadmin/email_data"]= "emailadmin/email_data/subscribe";
$route[ "emailsmssubscriptionsadmin/email_data/(:num)"]= "emailadmin/email_data/subscribe/1";
$route[ "emailsmssubscriptionsadmin/sms_data"]= "smsadmin/sms_data/subscribe";
$route[ "emailsmssubscriptionsadmin/sms_data/(:num)"]= "smsadmin/sms_data/subscribe/1";
$route[ "emailsmssubscriptionsadmin/email_resend"]= "emailadmin/resend/subscribe";
$route[ "emailsmssubscriptionsadmin/email_resend/(:any)"]= "emailadmin/resend/subscribe/$1";
$route[ "emailsmssubscriptionsadmin/bulk_resend"]= "emailadmin/bulk_resend/subscribe";
$route[ "emailsmssubscriptionsadmin/sms_resend"]= "smsadmin/resend/subscribe";
$route[ "emailsmssubscriptionsadmin/sms_resend/(:any)"]= "smsadmin/resend/subscribe/$1";
$route[ "emailsmssubscriptionsadmin/bulk_resend"]= "smsadmin/bulk_resend/subscribe";

$route[ "techsupportadmin/listemails"]= "emailadmin/listemails/techsupport";
$route[ "techsupportadmin/email_data"]= "emailadmin/email_data/techsupport";
$route[ "techsupportadmin/email_data/(:num)"]= "emailadmin/email_data/techsupport/1";
$route[ "techsupportadmin/email_resend"]= "emailadmin/resend/techsupport";
$route[ "techsupportadmin/email_resend/(:any)"]= "emailadmin/resend/techsupport/$1";
$route[ "techsupportadmin/bulk_resend"]= "emailadmin/bulk_resend/techsupport";

$route[ "vedoktashantiadmin/listemails"]= "emailadmin/listemails/vedoktashanti";
$route[ "vedoktashantiadmin/email_data"]= "emailadmin/email_data/vedoktashanti";
$route[ "vedoktashantiadmin/email_data/(:num)"]= "emailadmin/email_data/vedoktashanti/1";
$route[ "vedoktashantiadmin/email_resend"]= "emailadmin/resend/vedoktashanti";
$route[ "vedoktashantiadmin/email_resend/(:any)"]= "emailadmin/resend/vedoktashanti/$1";
$route[ "vedoktashantiadmin/bulk_resend"]= "emailadmin/bulk_resend/vedoktashanti";

$route[ "greetingsadmin/listemails"]= "emailadmin/listemails/greetings";
$route[ "greetingsadmin/email_data"]= "emailadmin/email_data/greetings";
$route[ "greetingsadmin/email_data/(:num)"]= "emailadmin/email_data/greetings/1";
$route[ "greetingsadmin/email_resend"]= "emailadmin/resend/greetings";
$route[ "greetingsadmin/email_resend/(:any)"]= "emailadmin/resend/greetings/$1";
$route[ "greetingsadmin/bulk_resend"]= "emailadmin/bulk_resend/greetings";

//=====Anagha Parayana routes=====//
$route[ "anaghavrataadmin/listsms"]= "smsadmin/listsms/anaghavrata";
$route[ "anaghavrataadmin/sms_data"]= "smsadmin/sms_data/anaghavrata";
$route[ "anaghavrataadmin/sms_data/(:num)"]= "smsadmin/sms_data/anaghavrata/1";
$route[ "anaghavrataadmin/sms_resend"]= "smsadmin/resend/anaghavrata";
$route[ "anaghavrataadmin/sms_resend/(:any)"]= "smsadmin/resend/anaghavrata/$1";
$route[ "anaghavrataadmin/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/anaghavrata";

$route[ "anagha-vrata-form"]= "anaghavrataform";
$route[ "anaghavratam"]= "anaghavrataform";
$route[ "anaghavrata"]= "anaghavrataform";
$route[ "anaghashtamivrata"]= "anaghavrataform";
$route[ "anaghashtamivratam"]= "anaghavrataform";
//=====Anagha Parayana routes=====//

//=====Hanuman Chalisa routes=====//
$route[ "hanumanchalisaadmin/listsms"]= "smsadmin/listsms/hanumanchalisa";
$route[ "hanumanchalisaadmin/sms_data"]= "smsadmin/sms_data/hanumanchalisa";
$route[ "hanumanchalisaadmin/sms_data/(:num)"]= "smsadmin/sms_data/hanumanchalisa/1";
$route[ "hanumanchalisaadmin/sms_resend"]= "smsadmin/resend/hanumanchalisa";
$route[ "hanumanchalisaadmin/sms_resend/(:any)"]= "smsadmin/resend/hanumanchalisa/$1";
$route[ "hanumanchalisaadmin/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/hanumanchalisa";

$route[ "hanuman-chalisa-form"]= "hanumanchalisaform";
$route[ "hanumanchalisa"]= "hanumanchalisaform";
$route[ "hanumanchalisaparayana"]= "hanumanchalisaform";
$route[ "chalisaparayana"]= "hanumanchalisaform";
//=====Hanuman Chalisa routes=====//

//=====Rama Mantra Parayana routes=====//
$route[ "ramamantraadmin/listsms"]= "smsadmin/listsms/ramamantra";
$route[ "ramamantraadmin/sms_data"]= "smsadmin/sms_data/ramamantra";
$route[ "ramamantraadmin/sms_data/(:num)"]= "smsadmin/sms_data/ramamantra/1";
$route[ "ramamantraadmin/sms_resend"]= "smsadmin/resend/ramamantra";
$route[ "ramamantraadmin/sms_resend/(:any)"]= "smsadmin/resend/ramamantra/$1";
$route[ "ramamantraadmin/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/ramamantra";

$route[ "rama-mantra-form"]= "ramamantraform";
$route[ "ramamantram"]= "ramamantraform";
$route[ "ramamantra"]= "ramamantraform";
$route[ "ramamantrajapa"]= "ramamantraform";
$route[ "ramamantraparayana"]= "ramamantraform";
//=====Rama Mantra routes=====//

//=====Vishwashanti Yatra 2022 routes=====//
$route[ "vishwashantipadayatra2022admin/listsms"]= "smsadmin/listsms/vishwashantipadayatra2022";
$route[ "vishwashantipadayatra2022admin/sms_data"]= "smsadmin/sms_data/vishwashantipadayatra2022";
$route[ "vishwashantipadayatra2022admin/sms_data/(:num)"]= "smsadmin/sms_data/vishwashantipadayatra2022/1";
$route[ "vishwashantipadayatra2022admin/sms_resend"]= "smsadmin/resend/vishwashantipadayatra2022";
$route[ "vishwashantipadayatra2022admin/sms_resend/(:any)"]= "smsadmin/resend/vishwashantipadayatra2022/$1";
$route[ "vishwashantipadayatra2022admin/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/vishwashantipadayatra2022";

$route[ "vishwashanti-pada-yatra-2022"]= "vishwashantipadayatra2022form";
$route[ "vishwashantipadayatra2022"]= "vishwashantipadayatra2022form";
$route[ "vishwashantipadayatra2022parayana"]= "vishwashantipadayatra2022form";
$route[ "chalisaparayana"]= "vishwashantipadayatra2022form";
//=====Vishwashanti Yatra 2022 routes=====//


//=====Shodasha Datta Kshetra Pada Yatra routes=====//
$route[ "shodashadattakshetrapadayatraadmin/listsms"]= "smsadmin/listsms/shodashadattakshetrapadayatra";
$route[ "shodashadattakshetrapadayatraadmin/sms_data"]= "smsadmin/sms_data/shodashadattakshetrapadayatra";
$route[ "shodashadattakshetrapadayatraadmin/sms_data/(:num)"]= "smsadmin/sms_data/shodashadattakshetrapadayatra/1";
$route[ "shodashadattakshetrapadayatraadmin/sms_resend"]= "smsadmin/resend/shodashadattakshetrapadayatra";
$route[ "shodashadattakshetrapadayatraadmin/sms_resend/(:any)"]= "smsadmin/resend/shodashadattakshetrapadayatra/$1";
$route[ "shodashadattakshetrapadayatraadmin/sms_bulk_resend"]= "smsadmin/sms_bulk_resend/shodashadattakshetrapadayatra";

$route[ "shodasha-datta-kshetra-pada-yatra-form"]= "shodashadattakshetrapadayatraform";
$route[ "shodasha-datta-kshetra-pada-yatra-vishwashanti-yatra-form"]= "shodashadattakshetrapadayatraform";
$route[ "shodasha-datta-kshetra-pada-yatra"]= "shodashadattakshetrapadayatraform";
$route[ "shodasha-datta-kshetra-pada-yatra-vishwashanti-yatra"]= "shodashadattakshetrapadayatraform";
//=====Shodasha Datta Kshetra Pada Yatra routes=====//

$route[ "pravachana-feedback"]= "pravachana_feedback";

$route[ "emailadmin/listemails"]= "myerror";

$route[ "about-us"]= "page/view/about-us";
$route[ "mantra-daanam"]= "page/view/mantra-daanam";

//=====General newsletters routes starts=====//
// $route[ "gennewslettersadmin/listemails"]= "emailadmin/listemails/subscribe";
// $route[ "gennewslettersadmin/listsms"]= "smsadmin/listsms/subscribe";
// $route[ "gennewslettersadmin/email_data"]= "emailadmin/email_data/subscribe";
// $route[ "gennewslettersadmin/email_data/(:num)"]= "emailadmin/email_data/subscribe/1";
// $route[ "gennewslettersadmin/sms_data"]= "smsadmin/sms_data/subscribe";
// $route[ "gennewslettersadmin/sms_data/(:num)"]= "smsadmin/sms_data/subscribe/1";
// $route[ "gennewslettersadmin/email_resend"]= "emailadmin/resend/subscribe";
// $route[ "gennewslettersadmin/email_resend/(:any)"]= "emailadmin/resend/subscribe/$1";
// $route[ "gennewslettersadmin/bulk_resend"]= "emailadmin/bulk_resend/subscribe";
// $route[ "gennewslettersadmin/sms_resend"]= "smsadmin/resend/subscribe";
// $route[ "gennewslettersadmin/sms_resend/(:any)"]= "smsadmin/resend/subscribe/$1";
// $route[ "gennewslettersadmin/bulk_resend"]= "smsadmin/bulk_resend/subscribe";
//=====General newsletters routes ends=====//



//=====SGS Birds Paradise routes starts=====//
$route[ "sgsbirdsparadise/about-us"]= "sgsbirdsparadise/about_us";
$route[ "sgsbirdsparadise/adopt-a-bird"]= "sgsbirdsparadise/adopt_a_bird";
$route[ "sgsbirdsparadise/adopt-a-bird1354"]= "sgsbirdsparadise/adopt_a_bird1354";
$route[ "sgsbirdsparadise/adopt-a-bird45f1"]= "sgsbirdsparadise/adopt_a_bird45f1";
$route[ "sgsbirdsparadise/adopt-a-bird620a"]= "sgsbirdsparadise/adopt_a_bird620a";
$route[ "sgsbirdsparadise/adopt-a-birda292"]= "sgsbirdsparadise/adopt_a_birda292";
$route[ "sgsbirdsparadise/adopt-a-birdc46f"]= "sgsbirdsparadise/adopt_a_birdc46f";
$route[ "sgsbirdsparadise/adopt-a-birdfad1"]= "sgsbirdsparadise/adopt_a_birdfad1";
$route[ "sgsbirdsparadise/adopt-a-birdfefe"]= "sgsbirdsparadise/adopt_a_birdfefe";
$route[ "sgsbirdsparadise/adopt-hand-tamed-bird"]= "sgsbirdsparadise/adopt_hand_tamed_bird";
$route[ "sgsbirdsparadise/become-a-sponsor"]= "sgsbirdsparadise/become_a_sponsor";
$route[ "sgsbirdsparadise/bird-rolodex"]= "sgsbirdsparadise/bird_rolodex";
$route[ "sgsbirdsparadise/contact-us"]= "sgsbirdsparadise/contact_us";
$route[ "sgsbirdsparadise/donate-anonymous"]= "sgsbirdsparadise/donate_anonymous";
$route[ "sgsbirdsparadise/feed-birds"]= "sgsbirdsparadise/feed_birds";
$route[ "sgsbirdsparadise/how-can-you-help"]= "sgsbirdsparadise/how_can_you_help";
$route[ "sgsbirdsparadise/member-blog"]= "sgsbirdsparadise/member_blog";
$route[ "sgsbirdsparadise/monthly-bird"]= "sgsbirdsparadise/monthly_bird";
$route[ "sgsbirdsparadise/musical-notes"]= "sgsbirdsparadise/musical_notes";
$route[ "sgsbirdsparadise/our-mission"]= "sgsbirdsparadise/our_mission";
$route[ "sgsbirdsparadise/our-success"]= "sgsbirdsparadise/our_success";
$route[ "sgsbirdsparadise/register-individual-member"]= "sgsbirdsparadise/register_individual_member";
$route[ "sgsbirdsparadise/register-organization"]= "sgsbirdsparadise/register_organization";
$route[ "sgsbirdsparadise/register-ornothologist_or_vet"]= "sgsbirdsparadise/register_ornothologist_or_vet";
$route[ "sgsbirdsparadise/register-vendor"]= "sgsbirdsparadise/register_vendor";
$route[ "sgsbirdsparadise/sponsor-supplies"]= "sgsbirdsparadise/sponsor_supplies";
$route[ "sgsbirdsparadise/what-we-do"]= "sgsbirdsparadise/what_we_do";
$route[ "sgsbirdsparadise/zodiac-signs"]= "sgsbirdsparadise/zodiac_signs";
$route[ "sgsbirdsparadise/bird-videos"]= "sgsbirdsparadise/bird_videos";
//=====SGS Birds Paradise routes ends=====//


?>