define({ "api": [
  {
    "type": "post",
    "url": "/ashrams",
    "title": "List of ashrams",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Ashrams",
    "group": "Ashrams",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n[\n          {\n              \"id\": \"4\",\n              \"name\": \"Avadhoota Datta Peetham (Main)\"\n          },\n          {\n              \"id\": \"10\",\n              \"name\": \"Sri Ganapati Sachchidananda Gnana Bodha Sabha Trust, Jaya Lakshmi Puram (Bommeparthy)\"\n          }\n      ]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Ashrams.php",
    "groupTitle": "Ashrams"
  },
  {
    "type": "post",
    "url": "/ashrams/change",
    "title": "Change current Ashram",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Change",
    "group": "Ashrams",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n\n         {\n             \"status\": true\n         }",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Ashrams.php",
    "groupTitle": "Ashrams"
  },
  {
    "type": "post",
    "url": "/ashrams/get",
    "title": "Get current Ashram",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Get",
    "group": "Ashrams",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n\n         {\n             \"id\": \"4\",\n             \"name\": \"Avadhoota Datta Peetham (Main)\"\n         }",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Ashrams.php",
    "groupTitle": "Ashrams"
  },
  {
    "type": "post",
    "url": "/calendar",
    "title": "Get Calendar",
    "name": "Calendar_list",
    "group": "Calendar",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Searches speeches</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "per_page",
            "description": "<p>Page Number</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "month",
            "description": "<p>Month (Valid only if year is set)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2",
              "3"
            ],
            "optional": true,
            "field": "calendar",
            "description": "<p>Calendar Type (1-Swamiji Calendar, 2-Bala Swamiji Calendar, 3- DattaPeetham Calendar)</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"num\": \"100\",\n           \"res\": [\n             {\n                 \"start_date\": \"01 Jan 2016\",\n                 \"end_date\": \"02 Jan 2016\",\n                 \"event_name\": \"Programs in Bengaluru Ashrama & Vagdevi school function\",\n                 \"swamiji\": \"0\",\n                 \"balaswamiji\": \"1\",\n                 \"dattapeetham\": \"0\",\n                 \"description\": \"<p>Sri Datta Vijayananda Teertha Swamiji in SGS Ashrama, Bengaluru</p>\",\n                 \"start_day\": \"Friday\",\n                 \"end_day\": \"Saturday\"\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "num",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "res",
            "description": "<p>Speech Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "res.start_date",
            "description": "<p>Start Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "res.end_date",
            "description": "<p>End Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.event_name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.swamiji",
            "description": "<p>Swamiji Calendar flag (0-No, 1-Yes)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.balaswamiji",
            "description": "<p>Bala Swamiji Calendar flag (0-No, 1-Yes)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.dattapeetham",
            "description": "<p>Dattapeetham Calendar flag (0-No, 1-Yes)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.start_day",
            "description": "<p>Day of the start date</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.end_day",
            "description": "<p>Day of the end date</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Calendar.php",
    "groupTitle": "Calendar"
  },
  {
    "type": "post",
    "url": "/calendar/get_years_months",
    "title": "Get possible years and months",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Years_and_months_list",
    "group": "Calendar",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"years\": [\n             {\n                 \"2016\",\n                 \"2015\"\n             },\n             \"months\": {\n                 \"2016\":\n                 [\n                     \"12\"\n                 ]\n             ],\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "years",
            "description": "<p>List of years</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "months",
            "description": "<p>Months Object (Keys will be years)</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "res",
            "description": "<p>['year'] List of months for that year</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Calendar.php",
    "groupTitle": "Calendar"
  },
  {
    "type": "post",
    "url": "/categories",
    "title": "List of Categories",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Categories",
    "group": "Categories",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n[\n          {\n              \"id\": \"4\",\n              \"category\": \"Category 1\",\n              \"parent\":0\n          },\n          {\n              \"id\": \"10\",\n              \"category\": \"Category 2\",\n              \"parent\":1\n          }\n      ]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Categories.php",
    "groupTitle": "Categories"
  },
  {
    "type": "post",
    "url": "/contact",
    "title": "Post a Contact",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Contact",
    "group": "Contact",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Name<br> Minlength:3<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID<br> Minlength:6<br> Maxlength:200</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "message",
            "description": "<p>Message<br> Minlength:1<br> Maxlength:1000</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'Personal Request'",
              "'Abuse'",
              "'Complaint'",
              "'Others'"
            ],
            "optional": false,
            "field": "purpose",
            "description": "<p>Purpose</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>Phone number<br> Minlength:5<br> Maxlength:100</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Contact.php",
    "groupTitle": "Contact"
  },
  {
    "type": "post",
    "url": "/currencies/change/:currency",
    "title": "Change current currency",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Change",
    "group": "Currencies",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n\n         {\n             \"status\": true\n         }",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Currencies.php",
    "groupTitle": "Currencies"
  },
  {
    "type": "post",
    "url": "/currencies",
    "title": "List of currencies",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Currencies",
    "group": "Currencies",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n[\n          {\n              \"currency\": \"INR\",\n              \"symbol\": \"₹\",\n              \"min\": \"10\",\n              \"max\": \"100000\",\n              \"color\": \"black\"\n          },\n          {\n              \"currency\": \"USD\",\n              \"symbol\": \"$\",\n              \"min\": \"10\",\n              \"max\": \"2500\",\n              \"color\": \"red\"\n          }\n      ]",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Currencies.php",
    "groupTitle": "Currencies"
  },
  {
    "type": "post",
    "url": "/currencies/get",
    "title": "Get current currency value",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Get",
    "group": "Currencies",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n\n         {\n             \"currency\": \"INR\",\n             \"symbol\": \"₹\",\n             \"min\": \"10\",\n             \"max\": \"100000\",\n             \"color\": \"black\"\n         }",
          "type": "json"
        }
      ]
    },
    "version": "0.0.0",
    "filename": "./Currencies.php",
    "groupTitle": "Currencies"
  },
  {
    "type": "post",
    "url": "/donations/add_to_cart/:donation_id",
    "title": "Add donation to cart",
    "permission": [
      {
        "name": "User"
      },
      {
        "name": "User"
      }
    ],
    "description": "<p>Rules:<br></p> <ol> <li>Can add same ashram donations.<br></li> <li>Maximum amounts are defined in currencies. Cart total cannot be greater than the specified amount.<br></li> <li>Admin cannot add items to cart</li> </ol>",
    "name": "Add_to_cart",
    "group": "Donations",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": true,
            "field": "Integer",
            "description": "<p>amount Amount</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/donations/get_cart",
    "title": "Donations cart",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Cart",
    "group": "Donations",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"7cbb43d3185e4e822ba1ecbc35612b22\":\n          {\n              \"id\": \"430\",\n              \"qty\": 1,\n              \"price\": 10,\n              \"name\": \"Some Donation\",\n              \"options\": {\n                  \"checksum\": \"060c341cb3c23793ffca39a249494fe2\",\n                  \"type\": \"donation\",\n                  \"note\": \"First name\\r\\nGothram\\r\\nNakshatram\",\n                  \"ashram_id\": \"4\",\n                  \"description\": \"Some Donation\",\n                  \"first_date\": \"10 Apr 2017\",\n                  \"user_date\": \"10 Apr 2017\",\n                  \"status\": 1,\n                  \"result_date\": \"31 Mar 2017\",\n                  \"price_inr\": \"1116\",\n                  \"price_suggested_inr\": \"100000\",\n                  \"price_usd\": \"2001\",\n                  \"price_suggested_usd\": \"2001\",\n              },\n              \"rowid\": \"7cbb43d3185e4e822ba1ecbc35612b22\",\n              \"subtotal\": 10\n          }\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "row_id",
            "description": "<p>Cart item object, row id will be the key</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.id",
            "description": "<p>Unique identifier of Donation</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.qty",
            "description": "<p>Quantity</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.price",
            "description": "<p>Price (IGNORE)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.name",
            "description": "<p>Donation name</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "row_id.options",
            "description": "<p>Donation item options object</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.checksum",
            "description": "<p>Checksum value for current cart item</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.type",
            "defaultValue": "donation",
            "description": "<p>Item type</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.note",
            "description": "<p>Family details</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.ashram_id",
            "description": "<p>Unique identifier of Ashram to which donation belong</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.description",
            "description": "<p>Description of donation</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.first_date",
            "description": "<p>First occurance date of current donation in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.user_date",
            "description": "<p>First occurance date of current donation in format dd MMM YYYY based on user selection</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.status",
            "description": "<p>Status of donation in cart (To checkout, all items must have status=1)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.result_date",
            "description": "<p>List of result dates separated with comma</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_inr",
            "description": "<p>Price in INR</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_suggested_inr",
            "description": "<p>Suggested price in INR</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_usd",
            "description": "<p>Price in USD</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_suggested_usd",
            "description": "<p>Suggested price in USD</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.rowid",
            "description": "<p>Row id of item in cart</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.subtotal",
            "description": "<p>Subtotal of items (IGNORE)</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/donations",
    "title": "Get Donations",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "List",
    "group": "Donations",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          {\n              \"id\": \"430\",\n              \"donation_name\": \"Shashvata Seva (Life time membership)\",\n              \"description\": \"Devotee Life time membership with Datta Peetham to support all activities of the Ashram\",\n              \"image\": \"https://dev.dattapeetham.org/images/donation_images/49.jpg\",\n              \"price_inr\": \"100000\",\n              \"price_usd\": \"2001\",\n              \"price\": \"INR 100000\"\n          }\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique identifier of Donation</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "donation_name",
            "description": "<p>Donation Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "image",
            "description": "<p>Donation Image</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "price_inr",
            "description": "<p>Price in INR</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "price_usd",
            "description": "<p>Price in USD</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "price",
            "description": "<p>Price with default Currency</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/donations/remove_from_cart/:row_id",
    "title": "Remove donation from cart",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Remove_from_cart",
    "group": "Donations",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\",\n          \"cart_count\": 1\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "cart_count",
            "description": "<p>Number of items remaining in cart. Set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/donations/update_family_details/:row_id",
    "title": "Update family details",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Update_family_details",
    "group": "Donations",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": true,
            "field": "String",
            "description": "<p>family_details Family Details<br> Minlength:6<br> Maxlength:500</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/donations/dates_validate/:row_id",
    "title": "Validate and save dates",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Validate_Dates",
    "group": "Donations",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "selected_dates",
            "description": "<p>User selected dates comma separated in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "Boolean",
            "optional": true,
            "field": "save",
            "description": "<p>If this is passed, dates are saved to cart else only returns valid dates</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\",\n          \"dates\": [\n              \"09 Apr 2017 (Sunday)\",\n              \"10 Apr 2017 (Monday)\"\n            ]\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "dates",
            "description": "<p>Array of resulting dates</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Donations.php",
    "groupTitle": "Donations"
  },
  {
    "type": "post",
    "url": "/events",
    "title": "Get events",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Events",
    "group": "Events",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Searches speeches</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "per_page",
            "description": "<p>Page Number</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "month",
            "description": "<p>Month (Valid only if year is set)</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"num\": \"1576\",\n           \"res\": [\n             {\n                 \"id\": \"1561\",\n                 \"name\": \"October 23, 2016\",\n                 \"description\": \"October 23\",\n                 \"start_date\": \"07 Mar 2016 (Mon)\",\n                 \"end_date\": \"08 Mar 2016 (Tue)\",\n                 \"location\": \"Mysore, India\",\n                 \"month\": \"3\",\n                 \"year\": \"2016\",\n                 \"slug\": \"maha-shivaratri-at-datta-peetham-2016\",\n                 \"start_date_raw\": \"07 Mar 2016\",\n                 \"end_date_raw\": \"08 Mar 2016\",\n                 \"color\": \"red\",\n                 \"thumb\": \"dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg\",\n                 \"thumb_url\": \"https://dev-dattapeetham.s3.amazonaws.com/..//..//dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg\",\n                 \"aws_s3_base_url\": \"https://dev-dattapeetham.s3.amazonaws.com/\"\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "num",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "res",
            "description": "<p>Events Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.start_date",
            "description": "<p>Start Date in format dd MMM YYYY (D)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.end_date",
            "description": "<p>End Date in format dd MMM YYYY (D)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.location",
            "description": "<p>Location of event</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.slug",
            "description": "<p>Slug</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "res.published_on",
            "description": "<p>Published Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.start_date_raw",
            "description": "<p>Start Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.end_date_raw",
            "description": "<p>End Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.thumb",
            "description": "<p>Thumbnail file name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.thumb_url",
            "description": "<p>Thumbnail URL</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.aws_s3_base_url",
            "description": "<p>CDN Base url for files</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Events.php",
    "groupTitle": "Events"
  },
  {
    "type": "post",
    "url": "/events/:id",
    "title": "Get an event",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Get",
    "group": "Events",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /events/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n        \"event\":\n        {\n            \"id\": \"3348\",\n            \"name\": \"Maha Shivaratri at Datta Peetham - 2016\",\n            \"start_date\": \"2016-03-07 00:00:00\",\n            \"end_date\": \"2016-03-08 00:00:00\",\n            \"description\": \"<p>The annual festival, Maha Shivaratri</p>\",\n            \"location\": \"Mysore, India\",\n            \"month\": \"3\",\n            \"year\": \"2016\",\n            \"slug\": \"maha-shivaratri-at-datta-peetham-2016\",\n            \"image_count\": \"0\",\n            \"categories\": \"\",\n            \"parent_link\": \"0\",\n            \"reads\": \"474\",\n            \"status\": \"1\"\n        },\n        \"images\":\n        [\n            {\n                \"id\": \"29036\",\n                \"event_id\": \"3348\",\n                \"filename\": \"dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg\",\n                \"description\": null,\n                \"order\": \"0\",\n                \"width\": \"500\",\n                \"height\": \"353\"\n            }\n        ]\n        \"attachments\":\n        [\n            {\n                \"id\": \"2309\",\n                \"event_id\": \"3334\",\n                \"filename\": \"dattapeetham_60a4849888accefcd639be5a4a765fee.jpg\",\n                \"description\": null,\n                \"order\": \"0\",\n                \"size\": \"226051\",\n                \"groupstring\": null\n            }\n        ]\n    }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "event",
            "description": "<p>Event object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.name",
            "description": "<p>Event Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.categories",
            "description": "<p>Category IDs with comma(,) separated</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.slug",
            "description": "<p>Slug value</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.location",
            "description": "<p>Location</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.parent_link",
            "description": "<p>Parent event Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "event.start_date",
            "description": "<p>Start Date in YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "event.end_date",
            "description": "<p>End Date in YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.reads",
            "description": "<p>Number of reads/views</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.status",
            "description": "<p>Status (Default 1)</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "images",
            "description": "<p>Images object (Empty if no images exist)<br>Image URL to be formed - &quot;{aws_s3_base_url}/content/event_images/{event_id}/thumb_{filename}&quot;</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.event_id",
            "description": "<p>Event ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.filename",
            "description": "<p>Image file name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.order",
            "description": "<p>Order</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.width",
            "description": "<p>Width of image</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.height",
            "description": "<p>Height of image</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "attachments",
            "description": "<p>Attachments object (Empty if no attachments exist)<br>Attachment URL to be formed - &quot;{aws_s3_base_url}/content/event_attachments/{event_id}/{filename}</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.event_id",
            "description": "<p>Event ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.filename",
            "description": "<p>Attachment file name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.order",
            "description": "<p>Order</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.size",
            "description": "<p>Size of file in bytes</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.groupstring",
            "description": "<p>Attachments with same 'groupstring' must be grouped with 'groupstring' as subheading</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Events.php",
    "groupTitle": "Events"
  },
  {
    "type": "post",
    "url": "/events/get_years_months",
    "title": "Get possible years and months",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Years_and_months_list",
    "group": "Events",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"years\": [\n             {\n                 \"2016\",\n                 \"2015\"\n             },\n             \"months\": {\n                 \"1996\":\n                 [\n                     \"12\"\n                 ]\n             ],\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "years",
            "description": "<p>List of years</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "months",
            "description": "<p>Months Object (Keys will be years)</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "res",
            "description": "<p>['year'] List of months for that year</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Events.php",
    "groupTitle": "Events"
  },
  {
    "type": "post",
    "url": "/eventsadmin/attachment_update_order",
    "title": "Update description for attachment",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Attachment_description",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "attachment_id",
            "description": "<p>Unique identifier of attachment</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "order",
            "description": "<p>Order of attachment<br> Minlength:1 Maxlength:3</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/attachment_update_description",
    "title": "Update description for attachment",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Attachment_description",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "attachment_id",
            "description": "<p>Unique identifier of attachment</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description<br> Minlength:0 Maxlength:200</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/check_name/:id",
    "title": "Check event name",
    "description": "<p>Check whether event name forms a valid slug and does not exist</p>",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Check_name",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Event name<br> Minlength:6 Maxlength:200</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/delete_attachment",
    "title": "Delete an attachment",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Delete_attachment",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "attachment_id",
            "description": "<p>Unique identifier of attachment</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"filename\": 'filename.jpg'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "filename",
            "description": "<p>File name of deleted attachment. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/delete/:id",
    "title": "Delete an Event",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Delete_event",
    "group": "Events_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"name\": \"Event Name\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Event name</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/delete_image",
    "title": "Delete an image",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Delete_image",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "image_id",
            "description": "<p>Unique identifier of image</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"filename\": 'filename.jpg'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "filename",
            "description": "<p>File name of deleted image. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin",
    "title": "Get events",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Events_list",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "category",
            "description": "<p>Category ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "name",
              "id"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"recordsTotal\": \"1576\",\n           \"data\": [\n             {\n                 \"id\": \"1561\",\n                 \"name\": \"October 23, 2016\",\n                 \"description\": \"October 23\",\n                 \"start_date\": \"07 Mar 2016 (Mon)\",\n                 \"end_date\": \"08 Mar 2016 (Tue)\",\n                 \"location\": \"Mysore, India\",\n                 \"month\": \"3\",\n                 \"year\": \"2016\",\n                 \"categories\":\"\",\n                 \"slug\": \"maha-shivaratri-at-datta-peetham-2016\",\n                 \"status\": \"1\",\n                 \"sno\": \"1\"\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Events Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.start_date",
            "description": "<p>Start Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.end_date",
            "description": "<p>End Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.location",
            "description": "<p>Location of event</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.slug",
            "description": "<p>Slug</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.categories",
            "description": "<p>Category ID(s) separated with comma(,)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial Number</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.status",
            "description": "<p>Status (1=Visible,0=Hidden)</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/:id",
    "title": "Get an event",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Get",
    "group": "Events_Admin",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /eventsadmin/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n        \"event\":\n        {\n            \"id\": \"3348\",\n            \"name\": \"Maha Shivaratri at Datta Peetham - 2016\",\n            \"start_date\": \"2016-03-07 00:00:00\",\n            \"end_date\": \"2016-03-08 00:00:00\",\n            \"description\": \"<p>The annual festival, Maha Shivaratri</p>\",\n            \"location\": \"Mysore, India\",\n            \"month\": \"3\",\n            \"year\": \"2016\",\n            \"slug\": \"maha-shivaratri-at-datta-peetham-2016\",\n            \"image_count\": \"0\",\n            \"categories\": \"\",\n            \"parent_link\": \"0\",\n            \"reads\": \"474\",\n            \"status\": \"1\"\n        },\n        \"images\":\n        [\n            {\n                \"id\": \"29036\",\n                \"event_id\": \"3348\",\n                \"filename\": \"dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg\",\n                \"description\": null,\n                \"order\": \"0\",\n                \"width\": \"500\",\n                \"height\": \"353\"\n            }\n        ]\n        \"attachments\":\n        [\n            {\n                \"id\": \"2309\",\n                \"event_id\": \"3334\",\n                \"filename\": \"dattapeetham_60a4849888accefcd639be5a4a765fee.jpg\",\n                \"description\": null,\n                \"order\": \"0\",\n                \"size\": \"226051\",\n                \"groupstring\": null\n            }\n        ]\n    }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "event",
            "description": "<p>Event object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.name",
            "description": "<p>Event Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.categories",
            "description": "<p>Category IDs with comma(,) separated</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.slug",
            "description": "<p>Slug value</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.location",
            "description": "<p>Location</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "event.parent_link",
            "description": "<p>Parent event Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "event.start_date",
            "description": "<p>Start Date in YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "event.end_date",
            "description": "<p>End Date in YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.reads",
            "description": "<p>Number of reads/views</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event.status",
            "description": "<p>Status (Default 1)</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "images",
            "description": "<p>Images object (Empty if no images exist)<br>Image URL to be formed - &quot;{aws_s3_base_url}/content/event_images/{event_id}/thumb_{filename}&quot;</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.event_id",
            "description": "<p>Event ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.filename",
            "description": "<p>Image file name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.order",
            "description": "<p>Order</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.width",
            "description": "<p>Width of image</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "images.height",
            "description": "<p>Height of image</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "attachments",
            "description": "<p>Attachments object (Empty if no attachments exist)<br>Attachment URL to be formed - &quot;{aws_s3_base_url}/content/event_attachments/{event_id}/{filename}</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.event_id",
            "description": "<p>Event ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.filename",
            "description": "<p>Attachment file name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.order",
            "description": "<p>Order</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.size",
            "description": "<p>Size of file in bytes</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "attachments.groupstring",
            "description": "<p>Attachments with same 'groupstring' must be grouped with 'groupstring' as subheading</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/image_update_description",
    "title": "Update description for image",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Image_description",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "image_id",
            "description": "<p>Unique identifier of image</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description<br> Minlength:0 Maxlength:200</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/image_update_order",
    "title": "Update description for image",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Image_description",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Unique identifier of Event</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "image_id",
            "description": "<p>Unique identifier of image</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "order",
            "description": "<p>Order of image<br> Minlength:1 Maxlength:3</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/post",
    "title": "Create/Post a new Event",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Post_event",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Event name<br> Minlength:6<br> Maxlength:200<br> Must be unique</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "location",
            "description": "<p>Location<br> Minlength:3<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "Array",
            "optional": false,
            "field": "categories",
            "description": "<p>Category ID(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_keywords",
            "description": "<p>SEO Keywords<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_description",
            "description": "<p>SEO Description<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "start_date",
            "description": "<p>Start date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "end_date",
            "description": "<p>End date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "parent_id",
            "description": "<p>Unique identifier of Parent event</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"event_id\": 4148\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "event_id",
            "description": "<p>Event ID of created event</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/update/:id",
    "title": "Update an Event",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Update",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Event name<br> Minlength:6<br> Maxlength:200<br> Must be unique</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "location",
            "description": "<p>Location<br> Minlength:3<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "Array",
            "optional": false,
            "field": "categories",
            "description": "<p>Category ID(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_keywords",
            "description": "<p>SEO Keywords<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_description",
            "description": "<p>SEO Description<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "start_date",
            "description": "<p>Start date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "end_date",
            "description": "<p>End date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "parent_id",
            "description": "<p>Unique identifier of Parent event</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/upload_attachement/:event_id",
    "title": "Upload a file/attachment",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Upload_attachment",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "File",
            "optional": false,
            "field": "files[]",
            "description": "<p>Image files<br> Excluded extensions: To be updated<br> Maxsize:5 MB</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"files\": [\n              {\n                  \"fileid\": 29194,\n                  \"filename\": \"dattapeetham_d4648ec5514d4f97c50fba1e14ae2c78.jpg\",\n                  \"title\": \"2015_audi_a3_29_1920x1080.jpg\",\n                  \"name\": \"2015_audi_a3_29_1920x1080.jpg\",\n                  \"type\": \"image/jpeg\",\n                  \"size\": 831974,\n                  \"status\": 1\n              }\n          ]\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "files",
            "description": "<p>Files object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.fileid",
            "description": "<p>Unique identifier of uploaded file</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.filename",
            "description": "<p>File name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.title",
            "description": "<p>Title</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.type",
            "description": "<p>MIME Type of file</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.size",
            "description": "<p>Size in bytes</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.status",
            "description": "<p>1 if success otherwise 0.<br> Please note that this status varies for multiple files.</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/eventsadmin/upload_image/:event_id",
    "title": "Upload an image",
    "permission": [
      {
        "name": "Super Admin, Content Admin"
      }
    ],
    "name": "Upload_image",
    "group": "Events_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "File",
            "optional": false,
            "field": "files[]",
            "description": "<p>Image files<br> Allowed image types:jpeg/png/jpg<br> Maxsize:5 MB</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"files\": [\n              {\n                  \"fileid\": 29194,\n                  \"filename\": \"dattapeetham_d4648ec5514d4f97c50fba1e14ae2c78.jpg\",\n                  \"title\": \"2015_audi_a3_29_1920x1080.jpg\",\n                  \"name\": \"2015_audi_a3_29_1920x1080.jpg\",\n                  \"type\": \"image/jpeg\",\n                  \"size\": 831974,\n                  \"status\": 1\n              }\n          ]\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "files",
            "description": "<p>Files object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.fileid",
            "description": "<p>Unique identifier of uploaded file</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.filename",
            "description": "<p>File name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.title",
            "description": "<p>Title</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "files.type",
            "description": "<p>MIME Type of file</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.size",
            "description": "<p>Size in bytes</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "files.status",
            "description": "<p>1 if success otherwise 0.<br> Please note that this status varies for multiple files.</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Eventsadmin.php",
    "groupTitle": "Events_Admin"
  },
  {
    "type": "post",
    "url": "/feedback/close/:feedback_id",
    "title": "Close a feedback request",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Close",
    "group": "Feedback",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"feedback_id\": 'FD-0099393'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedback.php",
    "groupTitle": "Feedback"
  },
  {
    "type": "post",
    "url": "/feedback/:id",
    "title": "Get a feedback message",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Get",
    "group": "Feedback",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /feedback/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"id\": \"9\",\n          \"feedback_id\": \"FB-2017-03-9\",\n          \"name\": \"Super Admin\",\n          \"email\": \"admin@admin.com\",\n          \"phone\": \"9988999999\",\n          \"purpose\": \"1\",\n          \"content\": \"message from API\",\n          \"ip_address\": \"117.98.217.92\",\n          \"user_agent\": \"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36\",\n          \"url\": \"\",\n          \"date\": \"2017-03-30 12:54:37\",\n          \"fstatus\": \"1\",\n          \"count\": \"0\",\n          \"replies_data\": {\n              \"replies\": [\n                  {\n                      \"id\": \"17\",\n                      \"feedback_id\": \"9\",\n                      \"content\": \"<p>This is a reply message</p>\",\n                      \"date\": \"2017-03-30 14:11:27\",\n                      \"userid\": \"308\",\n                      \"admin\": \"1\"\n                  }\n              ],\n              \"users\": {\n                  \"308\":\n                  {\n                      \"id\": \"308\",\n                      \"username\": \"datta2\",\n                      \"firstname\": \"Super\",\n                      \"lastname\": \"Admin\",\n                      \"email\": \"admin@admin.com\",\n                      \"profilepic\": \"\",\n                      \"phoneno\": \"9989999899\"\n                  }\n              }\n          }\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Name of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>Phone number of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "purpose",
            "description": "<p>Purpose</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "content",
            "description": "<p>Feedback Message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ip_address",
            "description": "<p>IP Address of the user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "user_agent",
            "description": "<p>User agent string</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>URL from where feedback sent. Empty for mobile app.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "date",
            "description": "<p>Date in format YYYY-mm-dd HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "fstatus",
            "description": "<p>Status of message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "count",
            "description": "<p>Number of feedback replies</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data",
            "description": "<p>Replies object contains replies and corresponding users data</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data.replies",
            "description": "<p>Replies object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.id",
            "description": "<p>Unique identifier of reply</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.feedback_id",
            "description": "<p>Unique identifier of feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.content",
            "description": "<p>Reply message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.date",
            "description": "<p>Date of reply in format YYYY-mm-dd HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.user_id",
            "description": "<p>User ID of replied user</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.admin",
            "description": "<p>1 if replied user is admin otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data.users",
            "description": "<p>Users object (User ID will be key for each user object)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.id",
            "description": "<p>Unique identifier of user</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.username",
            "description": "<p>Username</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.firstname",
            "description": "<p>First Name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.lastname",
            "description": "<p>Last Name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.email",
            "description": "<p>Email iD</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.profilepic",
            "description": "<p>Path of profile picture</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.phoneno",
            "description": "<p>Phone Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedback.php",
    "groupTitle": "Feedback"
  },
  {
    "type": "post",
    "url": "/feedback/post",
    "title": "Post a feedback",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "Post",
    "group": "Feedback",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "feed_phone",
            "description": "<p>Phone Number<br> Minlength:10<br> Maxlength:20</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2",
              "3",
              "4",
              "5",
              "6",
              "7"
            ],
            "optional": false,
            "field": "purpose",
            "description": "<p>Purpose<br> Reference:<br>array( 1=&gt;&quot;Office/Billing&quot;,<br> 2=&gt;&quot;Technical Support&quot;,<br> 3=&gt;&quot;Abuse&quot;,<br> 4=&gt;&quot;Complaint&quot;,<br> 5=&gt;&quot;Question&quot;,<br> 6=&gt;&quot;Feedback&quot;,<br> 7=&gt;&quot;Other&quot;<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "feed_msg",
            "description": "<p>Message<br> Minlength:1<br> Maxlength:500</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedback.php",
    "groupTitle": "Feedback"
  },
  {
    "type": "post",
    "url": "/feedback/reply/:feedback_id",
    "title": "Reply to a feedback request",
    "description": "<p>User can reply to a feedback message only when status is &quot;Waiting User&quot;.</p>",
    "name": "Reply",
    "group": "Feedback",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "reply",
            "description": "<p>Reply message</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"feedback_id\": 'FD-0099393'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedback.php",
    "groupTitle": "Feedback"
  },
  {
    "type": "post",
    "url": "/feedbackadmin/checkout/:feedback_id",
    "title": "Checkout from request",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Checkout",
    "group": "Feedback_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedbackadmin/close/:feedback_id",
    "title": "Close a feedback request",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Close",
    "group": "Feedback_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"feedback_id\": 'FD-0099393'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedbackadmin/:id",
    "title": "Get a feedback message",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Get",
    "group": "Feedback_Admin",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /feedback/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"id\": \"9\",\n          \"feedback_id\": \"FB-2017-03-9\",\n          \"name\": \"Super Admin\",\n          \"email\": \"admin@admin.com\",\n          \"phone\": \"9988999999\",\n          \"purpose\": \"Office/Billing\",\n          \"content\": \"message from API\",\n          \"ip_address\": \"117.98.217.92\",\n          \"user_agent\": \"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36\",\n          \"url\": \"\",\n          \"username\": \"datta2\",\n          \"date\": \"2017-03-30 12:54:37\",\n          \"fstatus\": \"1\",\n          \"count\": \"0\",\n          \"checked_in\": \"1\",\n          \"checked_in_time\": \"2017-03-30 15:23:02\",\n          \"checked_in_username\": \"datta2\",\n          \"replies_data\": {\n              \"replies\": [\n                  {\n                      \"id\": \"17\",\n                      \"feedback_id\": \"9\",\n                      \"content\": \"<p>This is a reply message</p>\",\n                      \"date\": \"2017-03-30 14:11:27\",\n                      \"userid\": \"308\",\n                      \"admin\": \"1\"\n                  }\n              ],\n              \"users\": {\n                  \"308\":\n                  {\n                      \"id\": \"308\",\n                      \"username\": \"datta2\",\n                      \"firstname\": \"Super\",\n                      \"lastname\": \"Admin\",\n                      \"email\": \"admin@admin.com\",\n                      \"profilepic\": \"\",\n                      \"phoneno\": \"9989999899\"\n                  }\n              }\n          }\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Name of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>Phone number of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "purpose",
            "description": "<p>Purpose</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "content",
            "description": "<p>Feedback Message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "ip_address",
            "description": "<p>IP Address of the user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "user_agent",
            "description": "<p>User agent string</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "url",
            "description": "<p>URL from where feedback sent. Empty for mobile app.</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "date",
            "description": "<p>Date in format YYYY-mm-dd HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "fstatus",
            "description": "<p>Status of message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "count",
            "description": "<p>Number of feedback replies</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "checked_in",
            "description": "<p>If admin checked in to message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "checked_in_time",
            "description": "<p>Checked in time in format yyyy-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "checked_in_username",
            "description": "<p>User ID of checked in admin</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data",
            "description": "<p>Replies object contains replies and corresponding users data</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data.replies",
            "description": "<p>Replies object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.id",
            "description": "<p>Unique identifier of reply</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.feedback_id",
            "description": "<p>Unique identifier of feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.content",
            "description": "<p>Reply message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.date",
            "description": "<p>Date of reply in format YYYY-mm-dd HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.user_id",
            "description": "<p>User ID of replied user</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.replies.admin",
            "description": "<p>1 if replied user is admin otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "replies_data.users",
            "description": "<p>Users object (User ID will be key for each user object)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.id",
            "description": "<p>Unique identifier of user</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.username",
            "description": "<p>Username</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.firstname",
            "description": "<p>First Name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.lastname",
            "description": "<p>Last Name</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.email",
            "description": "<p>Email iD</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.profilepic",
            "description": "<p>Path of profile picture</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "replies_data.users.phoneno",
            "description": "<p>Phone Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedbackadmin/reply/:feedback_id",
    "title": "Reply to a feedback request",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "description": "<p>Admin can reply to a feedback message only when status is &quot;Open or Waiting Admin&quot;.</p>",
    "name": "Reply",
    "group": "Feedback_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "reply",
            "description": "<p>Reply message</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"feedback_id\": 'FD-0099393'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedbackadmin/reply_guest/:feedback_id",
    "title": "Reply to a feedback request (Guest)",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "description": "<p>Admin can reply to a feedback message only when status is &quot;Open or Waiting Admin&quot;.</p>",
    "name": "Reply_guest",
    "group": "Feedback_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "subject",
            "description": "<p>Email subject<br> Minlength:6<br> Maxlength:200</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "reply",
            "description": "<p>Reply message</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"feedback_id\": 'FD-0099393'\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "feedback_id",
            "description": "<p>Feedback ID. This is set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedbackadmin",
    "title": "Get feedback messages",
    "name": "list",
    "group": "Feedback_Admin",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2"
            ],
            "optional": true,
            "field": "guests",
            "description": "<p>Guests filter<br> Reference:<br>array( 1=&gt;&quot;Users&quot;,<br> 2=&gt;&quot;Guests&quot; )</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2",
              "3",
              "4",
              "5",
              "6",
              "7"
            ],
            "optional": true,
            "field": "purpose",
            "description": "<p>Purpose<br> Reference:<br>array( 1=&gt;&quot;Office/Billing&quot;,<br> 2=&gt;&quot;Technical Support&quot;,<Br> 3=&gt;&quot;Abuse&quot;,<Br> 4=&gt;&quot;Complaint&quot;,<Br> 5=&gt;&quot;Question&quot;,<Br> 6=&gt;&quot;Feedback&quot;,<Br> 7=&gt;&quot;Other&quot;<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2",
              "3",
              "4"
            ],
            "optional": true,
            "field": "fstatus",
            "description": "<p>Status<br> Reference:<br>array( 1=&gt;&quot;Open&quot;,<br> 2=&gt;&quot;Waiting Admin&quot;,<br> 3=&gt;&quot;Waiting User&quot;,<br> 4=&gt;&quot;Closed&quot;<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "feedback_id",
              "content"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"recordsTotal\": \"1576\",\n           \"data\": [\n             {\n                 \"id\": \"9\",\n                 \"feedback_id\": \"FB-2017-03-9\",\n                 \"name\": \"Super Admin\",\n                 \"email\": \"admin@email.com\",\n                 \"phone\": \"9988999999\",\n                 \"purpose\": \"Office/Billing\",\n                 \"content\": \"message from API\",\n                 \"ip_address\": \"117.98.217.92\",\n                  \"url\": null,\n                 \"username\": \"datta2\",\n                 \"date\": \"30 Mar 2017\",\n                 \"modified_on\": \"30 Mar 2017 03:23 PM\",\n                 \"fstatus\": \"1\",\n                 \"count\": \"0\",\n                 \"read\": \"1\",\n                 \"read_user\": \"0\",\n                 \"checked_in\": \"1\",\n                 \"checked_in_time\": \"2017-03-30 15:23:02\",\n                 \"checked_in_username\": \"datta2\",\n                 \"sno\": 1\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Events Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.feedback_id",
            "description": "<p>Feedback ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.name",
            "description": "<p>Name of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.email",
            "description": "<p>Email ID of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.phone",
            "description": "<p>Phone number of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.purpose",
            "description": "<p>Purpose of feedback</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.content",
            "description": "<p>Feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.ip_address",
            "description": "<p>IP Address of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.url",
            "description": "<p>URL from which feedback posted (null for mobile)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.username",
            "description": "<p>User ID of posted user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.date",
            "description": "<p>Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.modified_on",
            "description": "<p>Modified date in format dd MMM YYYY hh:mm A</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.fstatus",
            "description": "<p>Status of feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.count",
            "description": "<p>Number of replies</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "data.read",
            "description": "<p>1 if Admin read the message otherwise 0</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "data.read_user",
            "description": "<p>1 if User read the message otherwise 0</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "data.checked_in",
            "description": "<p>If admin checked in to message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.checked_in_time",
            "description": "<p>Checked in time in format yyyy-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.checked_in_username",
            "description": "<p>User ID of checked in admin</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedbackadmin.php",
    "groupTitle": "Feedback_Admin"
  },
  {
    "type": "post",
    "url": "/feedback",
    "title": "Get feedback messages",
    "permission": [
      {
        "name": "Logged in User"
      }
    ],
    "name": "list",
    "group": "Feedback",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2",
              "3",
              "4"
            ],
            "optional": true,
            "field": "fstatus",
            "description": "<p>Status<br> Reference:<br>array( 1=&gt;&quot;Open&quot;,<br> 2=&gt;&quot;Waiting Admin&quot;,<br> 3=&gt;&quot;Waiting User&quot;,<br> 4=&gt;&quot;Closed&quot;<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "feedback_id",
              "content"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"recordsTotal\": \"1576\",\n           \"data\": [\n             {\n                 \"id\": \"9\",\n                 \"feedback_id\": \"FB-2017-03-9\",\n                 \"name\": \"Super Admin\",\n                 \"email\": \"admin@email.com\",\n                 \"phone\": \"9988999999\",\n                 \"purpose\": \"Office/Billing\",\n                 \"content\": \"message from API\",\n                 \"ip_address\": \"117.98.217.92\",\n                 \"date\": \"30 Mar 2017\",\n                 \"fstatus\": \"1\",\n                 \"count\": \"0\",\n                 \"read\": \"1\",\n                 \"read_user\": \"0\",\n                 \"sno\": 1\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Events Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.feedback_id",
            "description": "<p>Feedback ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.name",
            "description": "<p>Name of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.email",
            "description": "<p>Email ID of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.phone",
            "description": "<p>Phone number of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.purpose",
            "description": "<p>Purpose of feedback</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.content",
            "description": "<p>Feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.ip_address",
            "description": "<p>IP Address of user</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.date",
            "description": "<p>Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.fstatus",
            "description": "<p>Status of feedback message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.count",
            "description": "<p>Number of replies</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "data.read",
            "description": "<p>1 if Admin read the message otherwise 0</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "allowedValues": [
              "0",
              "1"
            ],
            "optional": false,
            "field": "data.read_user",
            "description": "<p>1 if User read the message otherwise 0</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Feedback.php",
    "groupTitle": "Feedback"
  },
  {
    "type": "post",
    "url": "/liveupdates",
    "title": "Get Live updates",
    "name": "List",
    "group": "Live_Updates",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Searches speeches</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "per_page",
            "description": "<p>Page Number</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2"
            ],
            "optional": true,
            "field": "type",
            "description": "<p>Type of message<br> Array(<br> 1=&gt;&quot;Text Message&quot;,<br> 2=&gt;&quot;Image&quot;<br> )</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"num\": \"1576\",\n           \"res\": [\n             {\n               \"id\": \"1561\",\n               \"message\": \"Live update message\",\n               \"order\": \"0\",\n               \"status\": \"1\",\n               \"created_on\": \"26 Oct 2016\",\n               \"color\": \"red\"\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "num",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "res",
            "description": "<p>Live updates Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.message",
            "description": "<p>Live update message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.order",
            "description": "<p>Order of message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.status",
            "description": "<p>Status (default 1)</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "res.created_on",
            "description": "<p>Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.color",
            "description": "<p>Color of record (Possible values: red, blue, green, orange, purple)</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Liveupdates.php",
    "groupTitle": "Live_Updates"
  },
  {
    "type": "post",
    "url": "/liveupdatesadmin/delete/:id",
    "title": "Delete a Live update",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Delete",
    "group": "Live_Updates_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"status\": \"true\"\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Liveupdatesadmin.php",
    "groupTitle": "Live_Updates_Admin"
  },
  {
    "type": "post",
    "url": "/liveupdatesadmin",
    "title": "Get Live updates",
    "description": "<p>Get liveupdates list. If any dependant fields are missing, error will not be displayed instead result falls back to default.</p>",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "List",
    "group": "Live_Updates_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "1",
              "2"
            ],
            "optional": true,
            "field": "type",
            "description": "<p>Type of message<br> Array(<br> 1=&gt;&quot;Text Message&quot;,<br> 2=&gt;&quot;Image&quot;<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "message"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in. Required along with 'search_text'</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern. Required along with 'search_text'</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"recordsTotal\": \"1576\",\n           \"data\": [\n             {\n                 \"id\": \"41\",\n                 \"message\": \"Pujya Sri Swamiji, Sadguru Sookti Sangraha – (Devotion – The Most Difficult Path)\",\n                 \"order\": \"0\",\n                 \"status\": \"1\",\n                 \"created_on\": \"2017-03-13 03:40:20\",\n                 \"sno\": 1\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Live updates Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.message",
            "description": "<p>Live update message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.order",
            "description": "<p>Order of message</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.status",
            "description": "<p>Status (default 1)</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "data.created_on",
            "description": "<p>Date in format YYYY-mm-dd HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Liveupdatesadmin.php",
    "groupTitle": "Live_Updates_Admin"
  },
  {
    "type": "post",
    "url": "/liveupdatesadmin/post",
    "title": "Post a Live update",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Post",
    "group": "Live_Updates_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "message",
            "description": "<p>Update message</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"status\": \"true\"\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Liveupdatesadmin.php",
    "groupTitle": "Live_Updates_Admin"
  },
  {
    "type": "post",
    "url": "/liveupdatesadmin/update_order/:id",
    "title": "Update order",
    "permission": [
      {
        "name": "Super Admin, Website Admin"
      }
    ],
    "name": "Update_Order",
    "group": "Live_Updates_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "order",
            "description": "<p>Order</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"status\": \"true\"\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Liveupdatesadmin.php",
    "groupTitle": "Live_Updates_Admin"
  },
  {
    "type": "post",
    "url": "/me/authenticate",
    "title": "Authenticate user",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Authenticate",
    "group": "Me",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Password<br> Minlength:5<br> Maxlength:50</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n     \"status\":true\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/change_password",
    "title": "Change Password",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Change_password",
    "group": "Me",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "current_password",
            "description": "<p>Current Password<br> Minlength:5<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "new_password",
            "description": "<p>New Password<br> Minlength:5<br> Maxlength:50</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/get_countries",
    "title": "Get countries list",
    "permission": [
      {
        "name": "User"
      }
    ],
    "description": "<p>Returns list of countries</p>",
    "name": "Countries_list",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true,\n         \"countries\":\n         {\n             {\n                 \"country_code\": \"AF\",\n                 \"country_name\": \"Afghanistan\",\n                 \"isd_code\": \"93\"\n             },\n             {\n                 \"country_code\": \"AX\",\n                 \"country_name\": \"Aland Islands\",\n                 \"isd_code\": \"358\"\n             },\n         }\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "countries",
            "description": "<p>Countries object</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "countries.country_code",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "countries.country_name",
            "description": "<p>Country Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "countries.isd_code",
            "description": "<p>Country ISD Code</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/languages_list",
    "title": "Get languages list",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Languages_list",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true,\n         \"languages\": [\n             {\n                 \"lang_id\": \"1\",\n                 \"lang_name\": \"Abaza\"\n             }\n         ]\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "languages",
            "description": "<p>Languages object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "languages.lang_id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "languages.lang_name",
            "description": "<p>Language Name</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/security_questions",
    "title": "Get user security questions",
    "permission": [
      {
        "name": "User"
      }
    ],
    "description": "<p>Returns user security questions</p>",
    "name": "Security_questions",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true,\n         \"question_ids\":\n         [\n             \"1\",\n             \"6\"\n         ]\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "question_ids",
            "description": "<p>Question IDs</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/security_questions_list",
    "title": "Get security questions list",
    "permission": [
      {
        "name": "User"
      }
    ],
    "description": "<p>Returns list of security questions in two groups</p>",
    "name": "Security_questions_list",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true,\n         \"security_questions\":\n         {\n             \"group0\":\n             [\n                 {\n                     \"id\": \"1\",\n                     \"question\": \"What was your childhood nickname?\",\n                     \"group\": \"0\"\n                 }\n             ],\n             \"group1\":\n             [\n                 {\n                     \"id\": \"1\",\n                     \"question\": \"What was your childhood nickname?\",\n                     \"group\": \"1\"\n                 }\n             ]\n         }\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "security_questions",
            "description": "<p>Security Questions object</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "security_questions.group0",
            "description": "<p>Security Questions object</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/update",
    "title": "Update profile",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Update",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n         \"status\": true\n     }",
          "type": "json"
        }
      ]
    },
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "user_email",
            "description": "<p>Email ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "[a-z]",
              "[A-Z]",
              "spaces"
            ],
            "optional": false,
            "field": "first_name",
            "description": "<p>First name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "middlename",
            "description": "<p>Middle name<br> Minlength:0<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "last_name",
            "description": "<p>Last name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'Priest/Veda Pandit'",
              "'Doctor'",
              "'Lawyer'",
              "'Government Employee'",
              "'Social Activist'",
              "'Bussiness Man'",
              "'Other'"
            ],
            "optional": false,
            "field": "profession",
            "description": "<p>Profession</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'Ashwini'",
              "'Bharani'",
              "'Krittika'",
              "'Rohini'",
              "'Mrigasira'",
              "'Arudra'",
              "'Punarvasu'",
              "'Pushyami'",
              "'Aslesha'",
              "'Magha'",
              "'P.Phalguni'",
              "'U.Phalguni'",
              "'Hasta'",
              "'Chitra'",
              "'Swati'",
              "'Visakha'",
              "'Anuradha'",
              "'Jyestha'",
              "'Moola'",
              "'P.Ashadha'",
              "'U.Ashadha'",
              "'Shravana'",
              "'Dhanishta'",
              "'Satabhistha'",
              "'P.Bhadra'",
              "'U.Bhadra'",
              "'Revati'"
            ],
            "optional": false,
            "field": "star",
            "description": "<p>Birth Star</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'Mesha'",
              "'Vrishuba'",
              "'Mithuna'",
              "'Karkataka'",
              "'Simha'",
              "'Kanya'",
              "'Tula'",
              "'Vruschika'",
              "'Dhanur'",
              "'Makara'",
              "'Kumbha'",
              "'Meena'"
            ],
            "optional": false,
            "field": "raasi",
            "description": "<p>Raasi<br> Array(<br> 'Mesha'=&gt;'Mesha (Aries)',<br> 'Vrishuba'=&gt;'Vrishuba (Taurus)',<br> 'Mithuna'=&gt;'Mithuna (Gemini)',<br> 'Karkataka'=&gt;'Karkataka (Cancer)',<br> 'Simha'=&gt;'Simha (Leo)',<br> 'Kanya'=&gt;'Kanya (Virgo)',<br> 'Tula'=&gt;'Tula (Libra)',<br> 'Vruschika'=&gt;'Vruschika (Scorpio)',<br> 'Dhanur'=&gt;'Dhanur (Sagittarius)',<br> 'Makara'=&gt;'Makara (Capricorn)',<br> 'Kumbha'=&gt;'Kumbha (Aquarius)',<br> 'Meena'=&gt;'Meena (Pisces)'<br> )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "gothram",
            "description": "<p>Gothram<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'Male'",
              "'Female'",
              "'Other'"
            ],
            "optional": false,
            "field": "gender",
            "description": "<p>Gender</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dob",
            "description": "<p>Date of Birth in dd MMM YYYY format.<br>Must be atleast 15 years old.</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "phone",
            "description": "<p>Phone number<br> Minlength:10<br> Maxlength:10<br> Digits only</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address",
            "description": "<p>Address line 1<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address1",
            "description": "<p>Address line 2<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address2",
            "description": "<p>Address line 3<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "state",
            "description": "<p>State Name<br> Minlength:2<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "city",
            "description": "<p>City<br> Minlength:2<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'"
            ],
            "optional": false,
            "field": "zip",
            "description": "<p>ZIP/PIN Code<br> Minlength:3<br> Maxlength:15</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "lang",
            "description": "<p>Language Identifier</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "family_details",
            "description": "<p>Family details<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "File",
            "optional": true,
            "field": "profile_image",
            "description": "<p>Profile Image<br> Maxsize: 1 MB</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me/update_security_questions",
    "title": "Update user security questions",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Update_Security_questions",
    "group": "Me",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Password<br> Minlength:5<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "q1",
            "description": "<p>Unique identifier of Question 1</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": false,
            "field": "q2",
            "description": "<p>Unique identifier of Question 2</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "ans1",
            "description": "<p>Answer 1<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "ans2",
            "description": "<p>Answer 2<br> Maxlength:100</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n   \"status\":true\n}",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/me",
    "title": "Get user's details",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "User",
    "group": "Me",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n         \"username\": \"exampleusername\",\n         \"firstname\": \"First Name\",\n         \"middlename\": \"Middle Name\",\n         \"lastname\": \"Last Name\",\n         \"email\": \"email@email.com\",\n         \"phoneno\": \"9988118811\",\n         \"profilepic\": \n             {\n                \"original\": \"https://dev-dattapeetham.s3.amazon.com/ssddd/sdddd.png\",\n                \"thumb\": \"https://dev-dattapeetham.s3.amazon.com/ssddd/thumb_sdddd.png\",\n                \"thumb50\": \"https://dev-dattapeetham.s3.amazon.com/ssddd/thumb50_sdddd.png\"\n             },\n         \"profession\": \"\",\n         \"gothram\": \"\",\n         \"birthstar\": \"\",\n         \"raasi\": \"\",\n         \"gender\": \"Male\",\n         \"dob\": \"1990-10-01\",\n         \"address\": \"Address line 1\",\n         \"address1\": \"Address line 2\",\n         \"address2\": \"Address Line 3\",\n         \"country_id\": \"IN\",\n         \"city\": \"Mysore\",\n         \"state\": \"Karnataka\",\n         \"country\": \"India\",\n         \"zipcode\": \"567386\",\n         \"lang_id\": \"314\",\n         \"admin\": \"0\",\n         \"email_verified\": \"1\",\n         \"family_details\": \"First name\\r\\nGothram\\r\\nNakshatram\"\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "username",
            "description": "<p>Username</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "firstname",
            "description": "<p>First Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "middlename",
            "description": "<p>Middle Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "lastname",
            "description": "<p>Last Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "phoneno",
            "description": "<p>Phone number</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "profilepic",
            "description": "<p>Multiple sizes of profile photo</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "original",
            "description": "<p>Original Size</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "thumb",
            "description": "<p>Thumnail of size 150x150</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "thumb50",
            "description": "<p>Thumbnail of size 50x50</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "profession",
            "description": "<p>Profession</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "gothram",
            "description": "<p>Gothram</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "birthstar",
            "description": "<p>Birth Star</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "raasi",
            "description": "<p>Raasi</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "gender",
            "description": "<p>Gender</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "dob",
            "description": "<p>Date of birth in format DD MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "address",
            "description": "<p>Address line 1</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "address1",
            "description": "<p>Address line 2</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "address2",
            "description": "<p>Address line 3</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "country_id",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "country",
            "description": "<p>Country Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "state",
            "description": "<p>State Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "city",
            "description": "<p>City Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "zipcode",
            "description": "<p>ZIP/PIN Code</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "lang_id",
            "description": "<p>Language Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "admin",
            "description": "<p>Admin flag</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "email_verified",
            "description": "<p>Email verified flag</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "family_details",
            "description": "<p>Family details</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Me.php",
    "groupTitle": "Me"
  },
  {
    "type": "post",
    "url": "/authenticate",
    "title": "Get access token",
    "name": "Authenticate",
    "group": "OAuth2",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "client_id",
            "description": "<p>Client ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "client_secret",
            "description": "<p>Client Secret</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "grant_type",
            "description": "<p>Grant type or scope. Default - 'password'</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "username",
            "description": "<p>Username of logging in user</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Password of logging in user</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"access_token\": \"545814da22216\",\n          \"expires_in\": 31536000,\n          \"token_type\": \"Bearer\",\n          \"scope\": 'password user',\n          \"refresh_token\": \"b6ef7d37d9c0d34e8bfaf8d0\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "access_token",
            "description": "<p>Access token</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "expired_in",
            "description": "<p>Expires in time (in seconds)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "token_type",
            "description": "<p>Default 'Bearer'</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "scope",
            "description": "<p>Default 'password user'</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "refresh_token",
            "description": "<p>Token used to get new token</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Authenticate.php",
    "groupTitle": "OAuth2"
  },
  {
    "type": "post",
    "url": "/authenticate/forgot_password",
    "title": "Forgot Password",
    "name": "Forgot_Password",
    "group": "OAuth2",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "username_email",
            "description": "<p>User ID or Email ID<br> Minlength:6<br> Maxlength:100</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"status\":true,\n          \"username\": \"manoj123\",\n          \"questions\": [\n              {\n                  \"id\": 1,\n                  \"question\": \"What was your childhood nickname?\"\n              },\n              {\n                  \"id\": 2,\n                  \"question\": \"In what city or town was your first job?\"\n              }\n          ]\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>Status of action</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "username",
            "description": "<p>User ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "questions",
            "description": "<p>List of questions</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "questions.id",
            "description": "<p>Serial number</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "questions.question",
            "description": "<p>Question</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Authenticate.php",
    "groupTitle": "OAuth2"
  },
  {
    "type": "post",
    "url": "/authenticate/refresh",
    "title": "Refresh an access token",
    "name": "Refresh",
    "group": "OAuth2",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "client_id",
            "description": "<p>Client ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "client_secret",
            "description": "<p>Client Secret</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "grant_type",
            "description": "<p>Grant type - 'refresh_token'</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "refresh_token",
            "description": "<p>Refresh token</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"access_token\": \"545814da22216\",\n          \"expires_in\": 31536000,\n          \"token_type\": \"Bearer\",\n          \"scope\": 'password user',\n          \"refresh_token\": \"b6ef7d37d9c0d34e8bfaf8d0\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "access_token",
            "description": "<p>Access token</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "expired_in",
            "description": "<p>Expires in time (in seconds)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "token_type",
            "description": "<p>Default 'Bearer'</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "scope",
            "description": "<p>Default 'password user'</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "refresh_token",
            "description": "<p>Token used to get new token</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Authenticate.php",
    "groupTitle": "OAuth2"
  },
  {
    "type": "post",
    "url": "/authenticate/register",
    "title": "Register a new User",
    "name": "Register",
    "group": "OAuth2",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "0-9"
            ],
            "optional": false,
            "field": "username",
            "description": "<p>User ID<br> Minlength:6<br> Maxlength:60</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "password",
            "description": "<p>Password<br> Minlength:5<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "rpassword",
            "description": "<p>Retype Password</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID<br> Minlength:6<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "A-Z",
              "spaces"
            ],
            "optional": false,
            "field": "firstname",
            "description": "<p>First Name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "A-Z",
              "spaces"
            ],
            "optional": false,
            "field": "middlename",
            "description": "<p>Middle Name<br> Minlength:0<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "A-Z",
              "spaces"
            ],
            "optional": false,
            "field": "lastname",
            "description": "<p>Last Name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "dob",
            "description": "<p>Date of Birth in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "Male",
              "Female"
            ],
            "optional": false,
            "field": "gender",
            "description": "<p>Gender</p>"
          },
          {
            "group": "Parameter",
            "type": "boolean",
            "optional": false,
            "field": "tnc",
            "description": "<p>Terms and Conditions accepted</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"status\":true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>Status of action</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Authenticate.php",
    "groupTitle": "OAuth2"
  },
  {
    "type": "post",
    "url": "/authenticate/security_check",
    "title": "Security questions validate",
    "name": "security_check",
    "group": "OAuth2",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "username_email",
            "description": "<p>User ID or Email ID<br> Minlength:6<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "answer1",
            "description": "<p>Answer to first question<br> Minlength:1<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "answer2",
            "description": "<p>Answer to second question<br> Minlength:1<br> Maxlength:100</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"status\":true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>Status of action</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Authenticate.php",
    "groupTitle": "OAuth2"
  },
  {
    "type": "post",
    "url": "/orders",
    "title": "Get Orders",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "List",
    "group": "Orders",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "transaction_id",
              "order_number"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          \"recordsTotal\": \"29\",\n          \"data\": [\n              {\n                  \"id\": \"131\",\n                  \"order_number\": \"O-2017-01-100131\",\n                  \"order_type\": \"1\",\n                  \"date\": \"27 Jan 2017\",\n                  \"username\": \"manoj123\",\n                  \"transaction_id\": \"A11AA33F56E7\",\n                  \"total_price\": \"USD 50\",\n                  \"price_in_words\": \"Fifty\",\n                  \"currency\": \"usd\",\n                  \"created_by\": \"1\",\n                  \"ashram_id\": \"4\",\n                  \"payment_mode\": \"PayPal\",\n                  \"firstname\": \"Manoj\",\n                  \"middlename\": null,\n                  \"lastname\": \"Mannepalli\",\n                  \"email\": \"saimanoj2008@gmail.com\",\n                  \"phone\": \"9009900990\",\n                  \"address1\": \"D No 301 Rukamani Apartments\",\n                  \"address2\": \"Road No 13\",\n                  \"address3\": \"West Marredpally\",\n                  \"city\": \"Secunderabad\",\n                  \"state\": \"Telangana\",\n                  \"country\": \"US\",\n                  \"ip_address\": \"223.230.117.69\",\n                  \"tokens\": \"0\",\n                  \"sno\": 1\n              },\n              {\n                  \"id\": \"131\",\n                  \"order_number\": \"O-2017-01-100131\",\n                  \"order_type\": \"1\",\n                  \"date\": \"27 Jan 2017\",\n                  \"username\": \"manoj123\",\n                  \"transaction_id\": \"A11AA33F56E7\",\n                  \"total_price\": \"USD 50\",\n                  \"price_in_words\": \"Fifty\",\n                  \"currency\": \"usd\",\n                  \"created_by\": \"1\",\n                  \"ashram_id\": \"4\",\n                  \"payment_mode\": \"PayPal\",\n                  \"firstname\": \"Manoj\",\n                  \"middlename\": null,\n                  \"lastname\": \"Mannepalli\",\n                  \"email\": \"saimanoj2008@gmail.com\",\n                  \"phone\": \"9009900990\",\n                  \"address1\": \"D No 301 Rukamani Apartments\",\n                  \"address2\": \"Road No 13\",\n                  \"address3\": \"West Marredpally\",\n                  \"city\": \"Secunderabad\",\n                  \"state\": \"Telangana\",\n                  \"country\": \"US\",\n                  \"ip_address\": \"223.230.117.69\",\n                  \"tokens\": \"0\",\n                  \"sno\": 1\n              }\n          ]\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of orders</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Orders object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique identifier of Order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.order_number",
            "description": "<p>Seva ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.order_type",
            "description": "<p>Type of Order (1=Pooja,2=Donation)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.date",
            "description": "<p>Seva Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.username",
            "description": "<p>User ID of user placed order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.transaction_id",
            "description": "<p>Transaction ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.total_price",
            "description": "<p>Total price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.price_in_words",
            "description": "<p>Price in words</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.currency",
            "description": "<p>Currency</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.created_by",
            "description": "<p>Created By (0=&gt;Guest,1=&gt;Admin,2=&gt;User)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.ashram_id",
            "description": "<p>Ashram ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.payment_mode",
            "description": "<p>Payment mode</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.firstname",
            "description": "<p>First name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.middlename",
            "description": "<p>Middle name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.lastname",
            "description": "<p>Last name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.email",
            "description": "<p>Email ID of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.phone",
            "description": "<p>Phone number of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address1",
            "description": "<p>Address Line 1</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address2",
            "description": "<p>Address Line 2</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address3",
            "description": "<p>Address Line 3</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.city",
            "description": "<p>City</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.state",
            "description": "<p>State</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.ip_address",
            "description": "<p>IP Address</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.tokens",
            "description": "<p>Tokens issued or not (1=&gt;Yes,0=&gt;No)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Orders.php",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/orders/:id",
    "title": "Order details",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Order_details",
    "group": "Orders",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          \"status\": true,\n          \"order\": {\n              \"id\": \"131\",\n              \"order_number\": \"O-2017-01-100131\",\n              \"order_type\": \"1\",\n              \"date\": \"2017-01-27 15:26:48\",\n              \"username\": \"manoj123\",\n              \"transaction_id\": \"A11AA33F56E7\",\n              \"total_price\": \"50\",\n              \"price_in_words\": \"Fifty\",\n              \"currency\": \"usd\",\n              \"created_by\": \"1\",\n              \"ashram_id\": \"4\",\n              \"payment_mode\": \"PayPal\",\n              \"firstname\": \"Manoj\",\n              \"middlename\": null,\n              \"lastname\": \"Mannepalli\",\n              \"email\": \"saimanoj2008@gmail.com\",\n              \"phone\": \"9009900990\",\n              \"address1\": \"Address line 1\",\n              \"address2\": \"Address line 2\",\n              \"address3\": \"Address line 3y\",\n              \"city\": \"Secunderabad\",\n              \"state\": \"Telangana\",\n              \"country\": \"US\",\n              \"ip_address\": \"223.230.117.69\",\n              \"tokens\": \"0\",\n              \"zipcode\": \"500026\",\n              \"initials\": \"sss\",\n              \"trust_name\": \"Trust Name\",\n              \"trust_address\": \"Address 1\\nAddress 2\",\n              \"ashram_footer\": \"Office Accounts\\nSGS Ashrama\\nMysore, India\"\n          },\n          \"order_items\": [\n              {\n                  \"id\": \"254\",\n                  \"quantity\": \"1\",\n                  \"item_name\": \"Appaji Birthday - Garland Seva\",\n                  \"price\": \"25\",\n                  \"note\": \"\",\n                  \"dates\": \"28 Jan 2017\"\n              },\n              {\n                  \"id\": \"255\",\n                  \"quantity\": \"1\",\n                  \"item_name\": \"Deepavali Mahalakshmi Puja, Bengaluru Ashrama\",\n                  \"price\": \"25\",\n                  \"note\": \"\",\n                  \"dates\": \"28 Jan 2017\"\n              }\n          ]\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "order",
            "description": "<p>Order object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.id",
            "description": "<p>Unique identifier of Order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.order_number",
            "description": "<p>Seva ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.order_type",
            "description": "<p>Type of Order (1=Pooja,2=Donation)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.date",
            "description": "<p>Seva Date</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.username",
            "description": "<p>User ID of user placed order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.transaction_id",
            "description": "<p>Transaction ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.total_price",
            "description": "<p>Total price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.price_in_words",
            "description": "<p>Price in words</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.currency",
            "description": "<p>Currency</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.created_by",
            "description": "<p>Created By (0=&gt;Guest,1=&gt;Admin,2=&gt;User)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.ashram_id",
            "description": "<p>Ashram ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.payment_mode",
            "description": "<p>Payment mode</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.firstname",
            "description": "<p>First name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.middlename",
            "description": "<p>Middle name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.lastname",
            "description": "<p>Last name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.email",
            "description": "<p>Email ID of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.phone",
            "description": "<p>Phone number of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address1",
            "description": "<p>Address Line 1</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address2",
            "description": "<p>Address Line 2</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address3",
            "description": "<p>Address Line 3</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.city",
            "description": "<p>City</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.state",
            "description": "<p>State</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.ip_address",
            "description": "<p>IP Address</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.tokens",
            "description": "<p>Tokens issued or not (1=&gt;Yes,0=&gt;No)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.zipcode",
            "description": "<p>ZIP Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.initials",
            "description": "<p>Initials</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.trust_name",
            "description": "<p>Trust Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.trust_address",
            "description": "<p>Trust Address</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.ashram_footer",
            "description": "<p>Footer HTML text (Refer to website view)</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "order_items",
            "description": "<p>Order items object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.quantity",
            "description": "<p>Quantity</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.item_name",
            "description": "<p>Name of item</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.price",
            "description": "<p>Price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.note",
            "description": "<p>Family details</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.dates",
            "description": "<p>Dates separated with comma</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Orders.php",
    "groupTitle": "Orders"
  },
  {
    "type": "post",
    "url": "/ordersadmin/issue_tokens/:id",
    "title": "Issue Tokens",
    "permission": [
      {
        "name": "Super Admin, Ashram Admin, Office Admin"
      }
    ],
    "name": "Issue_tokens",
    "group": "Orders_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Ordersadmin.php",
    "groupTitle": "Orders_Admin"
  },
  {
    "type": "post",
    "url": "/ordersadmin",
    "title": "Get Orders",
    "permission": [
      {
        "name": "Super Admin, Ashram Admin, Office Admin"
      }
    ],
    "name": "List",
    "group": "Orders_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "ashram_id",
            "description": "<p>Ashram ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "currency",
            "description": "<p>Currency</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "order_type",
            "description": "<p>Seva Type<br> Array(<br> 1=&gt;&quot;Poojas&quot;,<br> 2=&gt;&quot;Donations&quot; )</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "created_by",
            "description": "<p>Created By<br> Array(<br> 0=&gt;&quot;Guest&quot;,<br> 1=&gt;&quot;Admin&quot;,<br> 2=&gt;&quot;User&quot; )</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "tokens",
            "description": "<p>Token Status<br> Array(<br> 0=&gt;&quot;Not issued&quot;,<br> 1=&gt;&quot;Issued&quot; )</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "name",
              "id"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          \"recordsTotal\": \"29\",\n          \"data\": [\n              {\n                  \"id\": \"131\",\n                  \"order_number\": \"O-2017-01-100131\",\n                  \"order_type\": \"1\",\n                  \"date\": \"27 Jan 2017\",\n                  \"username\": \"manoj123\",\n                  \"transaction_id\": \"A11AA33F56E7\",\n                  \"total_price\": \"USD 50\",\n                  \"price_in_words\": \"Fifty\",\n                  \"currency\": \"usd\",\n                  \"created_by\": \"1\",\n                  \"ashram_id\": \"4\",\n                  \"payment_mode\": \"PayPal\",\n                  \"firstname\": \"Manoj\",\n                  \"middlename\": null,\n                  \"lastname\": \"Mannepalli\",\n                  \"email\": \"saimanoj2008@gmail.com\",\n                  \"phone\": \"9009900990\",\n                  \"address1\": \"D No 301 Rukamani Apartments\",\n                  \"address2\": \"Road No 13\",\n                  \"address3\": \"West Marredpally\",\n                  \"city\": \"Secunderabad\",\n                  \"state\": \"Telangana\",\n                  \"country\": \"US\",\n                  \"ip_address\": \"223.230.117.69\",\n                  \"tokens\": \"0\",\n                  \"sno\": 1\n              },\n              {\n                  \"id\": \"131\",\n                  \"order_number\": \"O-2017-01-100131\",\n                  \"order_type\": \"1\",\n                  \"date\": \"27 Jan 2017\",\n                  \"username\": \"manoj123\",\n                  \"transaction_id\": \"A11AA33F56E7\",\n                  \"total_price\": \"USD 50\",\n                  \"price_in_words\": \"Fifty\",\n                  \"currency\": \"usd\",\n                  \"created_by\": \"1\",\n                  \"ashram_id\": \"4\",\n                  \"payment_mode\": \"PayPal\",\n                  \"firstname\": \"Manoj\",\n                  \"middlename\": null,\n                  \"lastname\": \"Mannepalli\",\n                  \"email\": \"saimanoj2008@gmail.com\",\n                  \"phone\": \"9009900990\",\n                  \"address1\": \"D No 301 Rukamani Apartments\",\n                  \"address2\": \"Road No 13\",\n                  \"address3\": \"West Marredpally\",\n                  \"city\": \"Secunderabad\",\n                  \"state\": \"Telangana\",\n                  \"country\": \"US\",\n                  \"ip_address\": \"223.230.117.69\",\n                  \"tokens\": \"0\",\n                  \"sno\": 1\n              }\n          ]\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of orders</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Orders object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique identifier of Order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.order_number",
            "description": "<p>Seva ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.order_type",
            "description": "<p>Type of Order (1=Pooja,2=Donation)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.date",
            "description": "<p>Seva Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.username",
            "description": "<p>User ID of user placed order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.transaction_id",
            "description": "<p>Transaction ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.total_price",
            "description": "<p>Total price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.price_in_words",
            "description": "<p>Price in words</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.currency",
            "description": "<p>Currency</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.created_by",
            "description": "<p>Created By (0=&gt;Guest,1=&gt;Admin,2=&gt;User)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.ashram_id",
            "description": "<p>Ashram ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.payment_mode",
            "description": "<p>Payment mode</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.firstname",
            "description": "<p>First name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.middlename",
            "description": "<p>Middle name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.lastname",
            "description": "<p>Last name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.email",
            "description": "<p>Email ID of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.phone",
            "description": "<p>Phone number of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address1",
            "description": "<p>Address Line 1</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address2",
            "description": "<p>Address Line 2</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.address3",
            "description": "<p>Address Line 3</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.city",
            "description": "<p>City</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.state",
            "description": "<p>State</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.ip_address",
            "description": "<p>IP Address</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.tokens",
            "description": "<p>Tokens issued or not (1=&gt;Yes,0=&gt;No)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Ordersadmin.php",
    "groupTitle": "Orders_Admin"
  },
  {
    "type": "post",
    "url": "/ordersadmin/:id",
    "title": "Order details",
    "permission": [
      {
        "name": "Super Admin, Ashram Admin, Office Admin"
      }
    ],
    "name": "Order_details",
    "group": "Orders_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          \"status\": true,\n          \"order\": {\n              \"id\": \"131\",\n              \"order_number\": \"O-2017-01-100131\",\n              \"order_type\": \"1\",\n              \"date\": \"2017-01-27 15:26:48\",\n              \"username\": \"manoj123\",\n              \"transaction_id\": \"A11AA33F56E7\",\n              \"total_price\": \"50\",\n              \"price_in_words\": \"Fifty\",\n              \"currency\": \"usd\",\n              \"created_by\": \"1\",\n              \"ashram_id\": \"4\",\n              \"payment_mode\": \"PayPal\",\n              \"firstname\": \"Manoj\",\n              \"middlename\": null,\n              \"lastname\": \"Mannepalli\",\n              \"email\": \"saimanoj2008@gmail.com\",\n              \"phone\": \"9009900990\",\n              \"address1\": \"Address line 1\",\n              \"address2\": \"Address line 2\",\n              \"address3\": \"Address line 3y\",\n              \"city\": \"Secunderabad\",\n              \"state\": \"Telangana\",\n              \"country\": \"US\",\n              \"ip_address\": \"223.230.117.69\",\n              \"tokens\": \"0\",\n              \"zipcode\": \"500026\",\n              \"initials\": \"sss\",\n              \"trust_name\": \"Trust Name\",\n              \"trust_address\": \"Address 1\\nAddress 2\",\n              \"ashram_footer\": \"Office Accounts\\nSGS Ashrama\\nMysore, India\"\n          },\n          \"order_items\": [\n              {\n                  \"id\": \"254\",\n                  \"quantity\": \"1\",\n                  \"item_name\": \"Appaji Birthday - Garland Seva\",\n                  \"price\": \"25\",\n                  \"note\": \"\",\n                  \"dates\": \"28 Jan 2017\"\n              },\n              {\n                  \"id\": \"255\",\n                  \"quantity\": \"1\",\n                  \"item_name\": \"Deepavali Mahalakshmi Puja, Bengaluru Ashrama\",\n                  \"price\": \"25\",\n                  \"note\": \"\",\n                  \"dates\": \"28 Jan 2017\"\n              }\n          ]\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "order",
            "description": "<p>Order object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.id",
            "description": "<p>Unique identifier of Order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.order_number",
            "description": "<p>Seva ID</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.order_type",
            "description": "<p>Type of Order (1=Pooja,2=Donation)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.date",
            "description": "<p>Seva Date</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.username",
            "description": "<p>User ID of user placed order</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.transaction_id",
            "description": "<p>Transaction ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.total_price",
            "description": "<p>Total price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.price_in_words",
            "description": "<p>Price in words</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.currency",
            "description": "<p>Currency</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.created_by",
            "description": "<p>Created By (0=&gt;Guest,1=&gt;Admin,2=&gt;User)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.ashram_id",
            "description": "<p>Ashram ID</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.payment_mode",
            "description": "<p>Payment mode</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.firstname",
            "description": "<p>First name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.middlename",
            "description": "<p>Middle name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.lastname",
            "description": "<p>Last name of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.email",
            "description": "<p>Email ID of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.phone",
            "description": "<p>Phone number of User</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address1",
            "description": "<p>Address Line 1</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address2",
            "description": "<p>Address Line 2</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.address3",
            "description": "<p>Address Line 3</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.city",
            "description": "<p>City</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.state",
            "description": "<p>State</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.ip_address",
            "description": "<p>IP Address</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order.tokens",
            "description": "<p>Tokens issued or not (1=&gt;Yes,0=&gt;No)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.zipcode",
            "description": "<p>ZIP Code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.initials",
            "description": "<p>Initials</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.trust_name",
            "description": "<p>Trust Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.trust_address",
            "description": "<p>Trust Address</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order.ashram_footer",
            "description": "<p>Footer HTML text (Refer to website view)</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "order_items",
            "description": "<p>Order items object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.id",
            "description": "<p>Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.quantity",
            "description": "<p>Quantity</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.item_name",
            "description": "<p>Name of item</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_items.price",
            "description": "<p>Price</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.note",
            "description": "<p>Family details</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "order_items.dates",
            "description": "<p>Dates separated with comma</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Ordersadmin.php",
    "groupTitle": "Orders_Admin"
  },
  {
    "type": "post",
    "url": "/ordersadmin/send_order_details_email/:id",
    "title": "Order details email",
    "permission": [
      {
        "name": "Super Admin, Ashram Admin, Office Admin"
      }
    ],
    "name": "Order_details_email",
    "group": "Orders_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Ordersadmin.php",
    "groupTitle": "Orders_Admin"
  },
  {
    "type": "post",
    "url": "/ordersadmin/send_order_receipt_email/:id",
    "title": "Order receipt email",
    "permission": [
      {
        "name": "Super Admin, Ashram Admin, Office Admin"
      }
    ],
    "name": "Order_receipt_email",
    "group": "Orders_Admin",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Ordersadmin.php",
    "groupTitle": "Orders_Admin"
  },
  {
    "type": "post",
    "url": "/poojas/add_to_cart/:pooja_id",
    "title": "Add pooja to cart",
    "description": "<p>Rules:<br></p> <ol> <li>Can add same ashram poojas.<br></li> <li>Maximum amounts are defined in currencies. Cart total cannot be greater than the specified amount.<br></li> <li>Admin cannot add items to cart</li> </ol>",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Add_to_cart",
    "group": "Poojas",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/cancel_previous",
    "title": "Cancel previous transaction",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Cancel_transaction",
    "group": "Poojas",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\":true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/get_cart",
    "title": "Poojas cart",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Cart",
    "group": "Poojas",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"7cbb43d3185e4e822ba1ecbc35612b22\":\n          {\n              \"id\": \"430\",\n              \"qty\": 1,\n              \"price\": 10,\n              \"name\": \"Digambara Dattatreya Puja\",\n              \"options\": {\n                  \"checksum\": \"060c341cb3c23793ffca39a249494fe2\",\n                  \"type\": \"pooja\",\n                  \"note\": \"First name\\r\\nGothram\\r\\nNakshatram\",\n                  \"ashram_id\": \"4\",\n                  \"description\": \"Digambara Dattatreya Puja\",\n                  \"start_date\": \"2016-06-25\",\n                  \"end_date\": \"2017-08-31\",\n                  \"time_from\": \"10:30:00\",\n                  \"time_to\": \"13:00:00\",\n                  \"close_before\": \"0\",\n                  \"first_date\": \"31 Mar 2017\",\n                  \"user_date\": \"31 Mar 2017\",\n                  \"status\": 1,\n                  \"result_date\": \"31 Mar 2017\",\n                  \"price_inr\": \"1008\",\n                  \"price_usd\": \"25\"\n              },\n              \"rowid\": \"7cbb43d3185e4e822ba1ecbc35612b22\",\n              \"subtotal\": 10\n          }\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "row_id",
            "description": "<p>Cart item object, row id will be the key</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.id",
            "description": "<p>Unique identifier of Pooja</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.qty",
            "description": "<p>Quantity</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "row_id.price",
            "description": "<p>Price (IGNORE)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.name",
            "description": "<p>Pooja name</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "row_id.options",
            "description": "<p>Pooja item options object</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.checksum",
            "description": "<p>Checksum value for current cart item</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.type",
            "defaultValue": "pooja",
            "description": "<p>Item type</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.note",
            "description": "<p>Family details</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.ashram_id",
            "description": "<p>Unique identifier of Ashram to which pooja belong</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.description",
            "description": "<p>Description of pooja</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.start_date",
            "description": "<p>Start date in format yyyy-mm-dd</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.end_date",
            "description": "<p>End date in format yyyy-mm-dd</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.time_from",
            "description": "<p>From time in format HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.time_to",
            "description": "<p>To time in format HH:mm:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.close_before",
            "description": "<p>Number of minutes from end time before the pooja booking will be closed</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.first_date",
            "description": "<p>First occurance date of current pooja in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.user_date",
            "description": "<p>First occurance date of current pooja in format dd MMM YYYY based on user selection</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.status",
            "description": "<p>Status of pooja in cart (To checkout, all items must have status=1)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.result_date",
            "description": "<p>List of result dates separated with comma</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_inr",
            "description": "<p>Price in INR</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.options.price_usd",
            "description": "<p>Price in USD</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.rowid",
            "description": "<p>Row id of item in cart</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "row_id.subtotal",
            "description": "<p>Subtotal of items (IGNORE)</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas",
    "title": "Get Poojas",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "List",
    "group": "Poojas",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n[\n          {\n              \"id\": \"430\",\n              \"pooja_name\": \"Digambara Dattatreya Puja\",\n              \"description\": \"Digambara Dattatreya Puja\",\n              \"start_date\": \"25 Jun 2016\",\n              \"end_date\": \"31 Aug 2017\",\n              \"time_from\": \"10:30 AM\",\n              \"time_to\": \"01:00 PM\",\n              \"close_before\": \"0\",\n              \"image\": \"https://dev.dattapeetham.org/images/pooja_images/430.jpg\",\n              \"days\": \"\",\n              \"price_inr\": \"1008\",\n              \"price_usd\": \"25\",\n              \"price\": \"INR 1008\",\n              \"item_status\": 1\n          }\n      ]",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique identifier of Pooja</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "pooja_name",
            "description": "<p>Pooja Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "start_date",
            "description": "<p>Start Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "end_date",
            "description": "<p>End Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "time_from",
            "description": "<p>From time in format hh:mm A</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "time_to",
            "description": "<p>To time in format hh:mm A</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "close_before",
            "description": "<p>Number of minutes to close pooja before the end time</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "image",
            "description": "<p>Pooja Image</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "Days",
            "description": "<p>in a week</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "price_inr",
            "description": "<p>Price in INR</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "price_usd",
            "description": "<p>Price in USD</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "price",
            "description": "<p>Price with default Currency</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "status",
            "description": "<p>Poojas status</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/pay",
    "title": "Make Payment",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Pay",
    "group": "Poojas",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "A-Z",
              "spaces"
            ],
            "optional": false,
            "field": "firstname",
            "description": "<p>First Name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "a-z",
              "A-Z",
              "spaces"
            ],
            "optional": false,
            "field": "lastname",
            "description": "<p>Last Name<br> Minlength:2<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "email",
            "description": "<p>Email ID<br> Minlength:6<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "optional": false,
            "field": "phone",
            "description": "<p>Phone Number<br> Minlength:10<br> Maxlength:10<br> Digits only</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address1",
            "description": "<p>Address line 1<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address2",
            "description": "<p>Address line 2<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "address3",
            "description": "<p>Address line 3<br> Minlength:3<br> Maxlength:50</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "state",
            "description": "<p>State Name<br> Minlength:2<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'",
              "'[.-_@/]'",
              "'spaces'"
            ],
            "optional": false,
            "field": "city",
            "description": "<p>City<br> Minlength:2<br> Maxlength:100</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "'[a-z]'",
              "'[A-Z]'",
              "'[0-9]'"
            ],
            "optional": false,
            "field": "zipcode",
            "description": "<p>ZIP/PIN Code<br> Minlength:3<br> Maxlength:15</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "country",
            "description": "<p>Country Code</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "donation_initials",
            "description": "<p>Donation Initials<br> Minlength:3<br> Maxlength:25</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\":true,\n          \"payment_status\": 1,\n          \"order_id\":100\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "payment_status",
            "description": "<p>1 if success otherwise 0 (Set only for USD/Paypal)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "order_id",
            "description": "<p>Seva ID (Set only for USD/Paypal)</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "redirect_to",
            "description": "<p>URL to redirect to (Set only for INR/PayU)</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "time_exceed",
            "description": "<p>1 Sets only when transaction is already in process and initiated more than 5 minutes ago</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/remove_from_cart/:row_id",
    "title": "Remove pooja from cart",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Remove_from_cart",
    "group": "Poojas",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\",\n          \"cart_count\": 1\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "cart_count",
            "description": "<p>Number of items remaining in cart. Set only if status is true</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/update_family_details/:row_id",
    "title": "Update family details",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Update_family_details",
    "group": "Poojas",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "optional": true,
            "field": "String",
            "description": "<p>family_details Family Details<br> Minlength:6<br> Maxlength:500</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/poojas/dates_validate/:row_id",
    "title": "Validate and save dates",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Validate_Dates",
    "group": "Poojas",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "selected_dates",
            "description": "<p>User selected dates comma separated in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "Boolean",
            "optional": true,
            "field": "save",
            "description": "<p>If this is passed, dates are saved to cart else only returns valid dates</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n      {\n          \"status\": \"true\",\n          \"dates\": [\n              \"09 Apr 2017 (Sunday)\",\n              \"10 Apr 2017 (Monday)\"\n            ]\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "dates",
            "description": "<p>Array of resulting dates</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Poojas.php",
    "groupTitle": "Poojas"
  },
  {
    "type": "post",
    "url": "/quicklinks",
    "title": "Get Quick Links",
    "name": "List",
    "group": "Quick_Links",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           {\n             \"id\": \"1\",\n             \"title\": \"Sri Sri Swamiji Page\",\n             \"description\": \"Sri Sri Swamiji Page\",\n             \"link\": \"https://dev.dattapeetham.org/sriswamiji\"\n           }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "title",
            "description": "<p>Title</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "link",
            "description": "<p>Link</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Quicklinks.php",
    "groupTitle": "Quick_Links"
  },
  {
    "type": "post",
    "url": "/speeches/:id",
    "title": "Get a speech",
    "name": "Get",
    "group": "Speeches",
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /speeches/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n          \"id\": \"1561\",\n          \"name\": \"October 23, 2016\",\n          \"description\": \"Some html description\",\n          \"categories\": \"560\",\n          \"slug\": \"bhagavatam-day-258\",\n          \"published_on\": \"2016-10-26 00:00:00\",\n          \"year\": \"2016\",\n          \"month\": \"10\",\n          \"day\": \"26\",\n          \"parent_link\": \"1150\",\n          \"reads\": \"0\"\n        }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "categories",
            "description": "<p>Category IDs with comma(,) separated</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "slug",
            "description": "<p>Slug value</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "published_on",
            "description": "<p>Published Date in YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "day",
            "description": "<p>Day</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "parent_link",
            "description": "<p>Unique Identifier of Parent speech</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "reads",
            "description": "<p>Number of time the speech is read</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speeches.php",
    "groupTitle": "Speeches"
  },
  {
    "type": "post",
    "url": "/speeches/",
    "title": "Get speeches",
    "name": "Speeches",
    "group": "Speeches",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Searches speeches</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "per_page",
            "description": "<p>Page Number</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "month",
            "description": "<p>Month (Valid only if year is set)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "category",
            "description": "<p>Category ID</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"num\": \"1576\",\n           \"res\": [\n             {\n               \"id\": \"1561\",\n               \"name\": \"October 23, 2016\",\n               \"description\": \"October 23\",\n               \"categories\": \"561\",\n               \"slug\": \"october-23-2016\",\n               \"published_on\": \"26 Oct 2016\",\n               \"year\": \"2016\",\n               \"month\": \"10\",\n               \"day\": \"26\"\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "num",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "res",
            "description": "<p>Speech Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.categories",
            "description": "<p>Category IDs with comma(,) separated</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "res.slug",
            "description": "<p>Slug</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "res.published_on",
            "description": "<p>Published Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "res.day",
            "description": "<p>Day</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speeches.php",
    "groupTitle": "Speeches"
  },
  {
    "type": "post",
    "url": "/speeches/get_years_months",
    "title": "Get possible years and months",
    "permission": [
      {
        "name": "User"
      }
    ],
    "name": "Years_and_months_list",
    "group": "Speeches",
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"years\": [\n             {\n                 \"2016\",\n                 \"2015\"\n             },\n             \"months\": {\n                 \"1996\":\n                 [\n                     \"12\"\n                 ]\n             ],\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "years",
            "description": "<p>List of years</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "months",
            "description": "<p>Months Object (Keys will be years)</p>"
          },
          {
            "group": "Success 200",
            "type": "Array",
            "optional": false,
            "field": "res",
            "description": "<p>['year'] List of months for that year</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speeches.php",
    "groupTitle": "Speeches"
  },
  {
    "type": "post",
    "url": "/speechesadmin/check_name",
    "title": "Check speech name",
    "description": "<p>Check whether speech name forms a valid slug</p>",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "name": "Check_name",
    "group": "Speeches_Admin",
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech name<br> Minlength:6 Maxlength:200</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Boolean",
            "optional": false,
            "field": "status",
            "description": "<p>true if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  },
  {
    "type": "post",
    "url": "/speechesadmin/delete/:id",
    "title": "Delete a Speech",
    "name": "Delete_speech",
    "group": "Speeches_Admin",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"name\": \"Speech Name\"\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech name</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  },
  {
    "type": "post",
    "url": "/speechesadmin/:id",
    "title": "Get a speech",
    "name": "Get_a_speech",
    "group": "Speeches_Admin",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "examples": [
      {
        "title": "Example usage:",
        "content": "curl -i /speechesadmin/1561",
        "type": "curl"
      }
    ],
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n{\n        \"id\": \"3348\",\n        \"name\": \"Maha Shivaratri at Datta Peetham - 2016\",\n        \"description\": \"<p>The annual festival, Maha Shivaratri</p>\",\n        \"categories\": \"100,101\",\n        \"month\": \"3\",\n        \"year\": \"2016\",\n        \"day\": \"3\",\n        \"slug\": \"maha-shivaratri-at-datta-peetham-2016\",\n        \"published_on\": \"2017-03-13 00:00:00\",\n        \"seo_keywords\": \"seo_keywords\",\n        \"seo_description\": \"\",\n        \"parent_link\": \"0\",\n        \"reads\": \"474\",\n    }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "categories",
            "description": "<p>Category IDs with comma(,) separated</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "slug",
            "description": "<p>Slug value</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "parent_link",
            "description": "<p>Parent speech Unique identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "published_on",
            "description": "<p>Published Date in format YYYY-mm-dd HH:ii:ss</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "reads",
            "description": "<p>Number of reads/views</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "seo_keywords",
            "description": "<p>SEO Keywords</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "seo_description",
            "description": "<p>SEO Description</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  },
  {
    "type": "post",
    "url": "/speechesadmin/post",
    "title": "Create/Post a Speech",
    "name": "Post_speech",
    "group": "Speeches_Admin",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech name<br> Minlength:6<br> Maxlength:200</p>"
          },
          {
            "group": "Parameter",
            "type": "Array",
            "optional": false,
            "field": "categories",
            "description": "<p>Category ID(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "published_on",
            "description": "<p>Published date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_keywords",
            "description": "<p>SEO Keywords<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_description",
            "description": "<p>SEO Description<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "parent_id",
            "description": "<p>Unique identifier of Parent speech</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true,\n          \"speech_id\": 4148\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "speech_id",
            "description": "<p>Unique identifier of created speech</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  },
  {
    "type": "post",
    "url": "/speechesadmin",
    "title": "Get speeches",
    "name": "Speeches_list",
    "group": "Speeches_Admin",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "search_text",
            "description": "<p>Search keyword(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "start",
            "defaultValue": "0",
            "description": "<p>Number of record to start with</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "allowedValues": [
              "20",
              "50",
              "100"
            ],
            "optional": true,
            "field": "length",
            "description": "<p>Number of records to be displayed per page</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "category",
            "description": "<p>Category ID</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "from_date",
            "description": "<p>From Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": true,
            "field": "to_date",
            "description": "<p>To Date in format dd MM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "name",
              "id",
              "description"
            ],
            "optional": true,
            "field": "search_col",
            "description": "<p>Column name to search in</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "allowedValues": [
              "contains",
              "starts",
              "ends"
            ],
            "optional": true,
            "field": "wild",
            "description": "<p>Wild card pattern</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": "HTTP/1.1 200 OK\n {\n           \"recordsTotal\": \"1576\",\n           \"data\": [\n             {\n                 \"id\": \"1561\",\n                 \"name\": \"October 23, 2016\",\n                 \"description\": \"October 23\",\n                 \"categories\": \"560\",\n                 \"slug\": \"swamiji-speech-031717\",\n                 \"published_on\": \"13 Mar 2017\",\n                 \"year\": \"2017\",\n                 \"month\": \"3\",\n                 \"day\": \"13\",\n                 \"reads\": \"0\",\n                 \"sno\": 1\n             }\n     }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "recordsTotal",
            "description": "<p>Total number of results</p>"
          },
          {
            "group": "Success 200",
            "type": "Object",
            "optional": false,
            "field": "data",
            "description": "<p>Speeches Object</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.id",
            "description": "<p>Unique Identifier</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.name",
            "description": "<p>Name</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.description",
            "description": "<p>Description in HTML format/code</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.slug",
            "description": "<p>Slug</p>"
          },
          {
            "group": "Success 200",
            "type": "String",
            "optional": false,
            "field": "data.categories",
            "description": "<p>Category ID(s) separated with comma</p>"
          },
          {
            "group": "Success 200",
            "type": "Date",
            "optional": false,
            "field": "data.published_on",
            "description": "<p>Published Date in format dd MMM YYYY</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.year",
            "description": "<p>Year</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.month",
            "description": "<p>Month</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.day",
            "description": "<p>Day</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.reads",
            "description": "<p>Number of times read by public</p>"
          },
          {
            "group": "Success 200",
            "type": "Integer",
            "optional": false,
            "field": "data.sno",
            "description": "<p>Serial Number</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  },
  {
    "type": "post",
    "url": "/speechesadmin/update/:id",
    "title": "Update a Speech",
    "name": "Update",
    "group": "Speeches_Admin",
    "permission": [
      {
        "name": "Super Admin, Content Admin, Speeches Admin"
      }
    ],
    "parameter": {
      "fields": {
        "Parameter": [
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "name",
            "description": "<p>Speech name<br> Minlength:6<br> Maxlength:200</p>"
          },
          {
            "group": "Parameter",
            "type": "Array",
            "optional": false,
            "field": "categories",
            "description": "<p>Category ID(s)</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "published_on",
            "description": "<p>Published date in format dd MMM YYYY</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_keywords",
            "description": "<p>SEO Keywords<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "seo_description",
            "description": "<p>SEO Description<br> Minlength:10<br> Maxlength:500</p>"
          },
          {
            "group": "Parameter",
            "type": "String",
            "optional": false,
            "field": "description",
            "description": "<p>Description</p>"
          },
          {
            "group": "Parameter",
            "type": "Integer",
            "optional": true,
            "field": "parent_id",
            "description": "<p>Unique identifier of Parent speech</p>"
          }
        ]
      }
    },
    "success": {
      "examples": [
        {
          "title": "Success-Response:",
          "content": " HTTP/1.1 200 OK\n{\n          \"status\": true\n      }",
          "type": "json"
        }
      ],
      "fields": {
        "Success 200": [
          {
            "group": "Success 200",
            "type": "boolean",
            "optional": false,
            "field": "status",
            "description": "<p>True if success otherwise false</p>"
          }
        ]
      }
    },
    "version": "0.0.0",
    "filename": "./Speechesadmin.php",
    "groupTitle": "Speeches_Admin"
  }
] });
